/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.simibubi.create.content.contraptions.TorquePropagator;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelTileEntity;
import com.simibubi.create.foundation.advancement.AllTriggers;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class KineticNetwork {
    public Long id;
    public boolean initialized;
    public boolean containsFlywheel = false;
    public Map<KineticTileEntity, Float> sources = new HashMap<KineticTileEntity, Float>();
    public Map<KineticTileEntity, Float> members = new HashMap<KineticTileEntity, Float>();
    private float currentCapacity;
    private float currentStress;
    private float unloadedCapacity;
    private float unloadedStress;
    private int unloadedMembers;

    public void initFromTE(float maxStress, float currentStress, int members) {
        this.unloadedCapacity = maxStress;
        this.unloadedStress = currentStress;
        this.unloadedMembers = members;
        this.initialized = true;
        this.updateStress();
        this.updateCapacity();
    }

    public void addSilently(KineticTileEntity te, float lastCapacity, float lastStress) {
        if (this.members.containsKey(te)) {
            return;
        }
        if (te.isSource()) {
            this.unloadedCapacity -= lastCapacity * KineticNetwork.getStressMultiplierForSpeed(te.getGeneratedSpeed());
            float addedStressCapacity = te.calculateAddedStressCapacity();
            this.sources.put(te, Float.valueOf(addedStressCapacity));
            this.containsFlywheel |= te instanceof FlywheelTileEntity;
        }
        this.unloadedStress -= lastStress * KineticNetwork.getStressMultiplierForSpeed(te.getTheoreticalSpeed());
        float stressApplied = te.calculateStressApplied();
        this.members.put(te, Float.valueOf(stressApplied));
        --this.unloadedMembers;
        if (this.unloadedMembers < 0) {
            this.unloadedMembers = 0;
        }
        if (this.unloadedCapacity < 0.0f) {
            this.unloadedCapacity = 0.0f;
        }
        if (this.unloadedStress < 0.0f) {
            this.unloadedStress = 0.0f;
        }
    }

    public void add(KineticTileEntity te) {
        if (this.members.containsKey(te)) {
            return;
        }
        if (te.isSource()) {
            this.sources.put(te, Float.valueOf(te.calculateAddedStressCapacity()));
        }
        this.members.put(te, Float.valueOf(te.calculateStressApplied()));
        this.updateFromNetwork(te);
        te.networkDirty = true;
    }

    public void updateCapacityFor(KineticTileEntity te, float capacity) {
        this.sources.put(te, Float.valueOf(capacity));
        this.updateCapacity();
    }

    public void updateStressFor(KineticTileEntity te, float stress) {
        this.members.put(te, Float.valueOf(stress));
        this.updateStress();
    }

    public void remove(KineticTileEntity te) {
        if (!this.members.containsKey(te)) {
            return;
        }
        if (te.isSource()) {
            this.sources.remove(te);
        }
        this.members.remove(te);
        te.updateFromNetwork(0.0f, 0.0f, 0);
        if (this.members.isEmpty()) {
            TorquePropagator.networks.get(te.func_145831_w()).remove(this.id);
            return;
        }
        this.members.keySet().stream().findFirst().map(member -> {
            member.networkDirty = true;
            return true;
        });
    }

    public void sync() {
        for (KineticTileEntity te : this.members.keySet()) {
            this.updateFromNetwork(te);
        }
    }

    private void updateFromNetwork(KineticTileEntity te) {
        boolean wasOverStressed = te.isOverStressed();
        te.updateFromNetwork(this.currentCapacity, this.currentStress, this.getSize());
        if (!wasOverStressed && te.isOverStressed() && te.getTheoreticalSpeed() != 0.0f) {
            AllTriggers.triggerForNearbyPlayers(AllTriggers.OVERSTRESSED, te.func_145831_w(), te.func_174877_v(), 4);
            if (this.containsFlywheel) {
                AllTriggers.triggerForNearbyPlayers(AllTriggers.OVERSTRESS_FLYWHEEL, te.func_145831_w(), te.func_174877_v(), 4);
            }
        }
    }

    public void updateCapacity() {
        float newMaxStress = this.calculateCapacity();
        if (this.currentCapacity != newMaxStress) {
            this.currentCapacity = newMaxStress;
            this.sync();
        }
    }

    public void updateStress() {
        float newStress = this.calculateStress();
        if (this.currentStress != newStress) {
            this.currentStress = newStress;
            this.sync();
        }
    }

    public void updateNetwork() {
        float newStress = this.calculateStress();
        float newMaxStress = this.calculateCapacity();
        if (this.currentStress != newStress || this.currentCapacity != newMaxStress) {
            this.currentStress = newStress;
            this.currentCapacity = newMaxStress;
            this.sync();
        }
    }

    public float calculateCapacity() {
        float presentCapacity = 0.0f;
        this.containsFlywheel = false;
        Iterator<KineticTileEntity> iterator = this.sources.keySet().iterator();
        while (iterator.hasNext()) {
            KineticTileEntity te = iterator.next();
            if (te.func_145831_w().func_175625_s(te.func_174877_v()) != te) {
                iterator.remove();
                continue;
            }
            this.containsFlywheel |= te instanceof FlywheelTileEntity;
            presentCapacity += this.getActualCapacityOf(te);
        }
        float newMaxStress = presentCapacity + this.unloadedCapacity;
        return newMaxStress;
    }

    public float calculateStress() {
        float presentStress = 0.0f;
        Iterator<KineticTileEntity> iterator = this.members.keySet().iterator();
        while (iterator.hasNext()) {
            KineticTileEntity te = iterator.next();
            if (te.func_145831_w().func_175625_s(te.func_174877_v()) != te) {
                iterator.remove();
                continue;
            }
            presentStress += this.getActualStressOf(te);
        }
        float newStress = presentStress + this.unloadedStress;
        return newStress;
    }

    public float getActualCapacityOf(KineticTileEntity te) {
        return this.sources.get(te).floatValue() * KineticNetwork.getStressMultiplierForSpeed(te.getGeneratedSpeed());
    }

    public float getActualStressOf(KineticTileEntity te) {
        return this.members.get(te).floatValue() * KineticNetwork.getStressMultiplierForSpeed(te.getTheoreticalSpeed());
    }

    private static float getStressMultiplierForSpeed(float speed) {
        return Math.abs(speed);
    }

    public int getSize() {
        return this.unloadedMembers + this.members.size();
    }
}

