/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.base;

import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.foundation.utility.DirectionHelper;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class DirectionalAxisKineticBlock
extends DirectionalKineticBlock {
    public static final BooleanProperty AXIS_ALONG_FIRST_COORDINATE = BooleanProperty.func_177716_a((String)"axis_along_first");

    public DirectionalAxisKineticBlock(Block.Properties properties) {
        super(properties);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AXIS_ALONG_FIRST_COORDINATE});
        super.func_206840_a(builder);
    }

    protected Direction getFacingForPlacement(BlockItemUseContext context) {
        Direction facing = context.func_196010_d().func_176734_d();
        if (context.func_195999_j() != null && context.func_195999_j().func_225608_bj_()) {
            facing = facing.func_176734_d();
        }
        return facing;
    }

    protected boolean getAxisAlignmentForPlacement(BlockItemUseContext context) {
        return context.func_195992_f().func_176740_k() == Direction.Axis.X;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = this.getFacingForPlacement(context);
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        boolean alongFirst = false;
        Direction.Axis faceAxis = facing.func_176740_k();
        if (faceAxis.func_176722_c()) {
            alongFirst = faceAxis == Direction.Axis.Z;
            Direction positivePerpendicular = DirectionHelper.getPositivePerpendicular(faceAxis);
            boolean shaftAbove = this.prefersConnectionTo((IWorldReader)world, pos, Direction.UP, true);
            boolean shaftBelow = this.prefersConnectionTo((IWorldReader)world, pos, Direction.DOWN, true);
            boolean preferLeft = this.prefersConnectionTo((IWorldReader)world, pos, positivePerpendicular, false);
            boolean preferRight = this.prefersConnectionTo((IWorldReader)world, pos, positivePerpendicular.func_176734_d(), false);
            if (shaftAbove || shaftBelow || preferLeft || preferRight) {
                boolean bl = alongFirst = faceAxis == Direction.Axis.X;
            }
        }
        if (faceAxis.func_200128_b()) {
            alongFirst = this.getAxisAlignmentForPlacement(context);
            Direction prefferedSide = null;
            for (Direction side : Iterate.horizontalDirections) {
                if (!this.prefersConnectionTo((IWorldReader)world, pos, side, true) && !this.prefersConnectionTo((IWorldReader)world, pos, side.func_176746_e(), false)) continue;
                if (prefferedSide != null && prefferedSide.func_176740_k() != side.func_176740_k()) {
                    prefferedSide = null;
                    break;
                }
                prefferedSide = side;
            }
            if (prefferedSide != null) {
                alongFirst = prefferedSide.func_176740_k() == Direction.Axis.X;
            }
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)facing)).func_206870_a((IProperty)AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(alongFirst));
    }

    protected boolean prefersConnectionTo(IWorldReader reader, BlockPos pos, Direction facing, boolean shaftAxis) {
        if (!shaftAxis) {
            return false;
        }
        BlockPos neighbourPos = pos.func_177972_a(facing);
        BlockState blockState = reader.func_180495_p(neighbourPos);
        Block block = blockState.func_177230_c();
        return block instanceof IRotate && ((IRotate)block).hasShaftTowards(reader, neighbourPos, blockState, facing.func_176734_d());
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        Direction.Axis pistonAxis = ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k();
        boolean alongFirst = (Boolean)state.func_177229_b((IProperty)AXIS_ALONG_FIRST_COORDINATE);
        if (pistonAxis == Direction.Axis.X) {
            return alongFirst ? Direction.Axis.Y : Direction.Axis.Z;
        }
        if (pistonAxis == Direction.Axis.Y) {
            return alongFirst ? Direction.Axis.X : Direction.Axis.Z;
        }
        if (pistonAxis == Direction.Axis.Z) {
            return alongFirst ? Direction.Axis.X : Direction.Axis.Y;
        }
        throw new IllegalStateException("Unknown axis??");
    }

    @Override
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        if (rot.ordinal() % 2 == 1) {
            state = (BlockState)state.func_177231_a((IProperty)AXIS_ALONG_FIRST_COORDINATE);
        }
        return super.func_185499_a(state, rot);
    }

    @Override
    public boolean hasShaftTowards(IWorldReader world, BlockPos pos, BlockState state, Direction face) {
        return face.func_176740_k() == this.getRotationAxis(state);
    }
}

