/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.base;

import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.KineticNetwork;
import com.simibubi.create.content.contraptions.RotationPropagator;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticBlock;
import com.simibubi.create.content.contraptions.base.KineticEffectHandler;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.render.backend.FastRenderDispatcher;
import com.simibubi.create.foundation.render.backend.instancing.IInstanceRendered;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class KineticTileEntity
extends SmartTileEntity
implements ITickableTileEntity,
IHaveGoggleInformation,
IHaveHoveringInformation,
IInstanceRendered {
    @Nullable
    public Long network;
    @Nullable
    public BlockPos source;
    public boolean networkDirty;
    public boolean updateSpeed = true;
    public boolean preventSpeedUpdate;
    protected KineticEffectHandler effects = new KineticEffectHandler(this);
    protected float speed;
    protected float capacity;
    protected float stress;
    protected boolean overStressed;
    protected boolean wasMoved;
    private int flickerTally;
    private int networkSize;
    private int validationCountdown;
    protected float lastStressApplied;
    protected float lastCapacityProvided;
    protected AxisAlignedBB cachedBoundingBox;

    public KineticTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    @Override
    public void initialize() {
        if (this.hasNetwork() && !this.field_145850_b.field_72995_K) {
            KineticNetwork network = this.getOrCreateNetwork();
            if (!network.initialized) {
                network.initFromTE(this.capacity, this.stress, this.networkSize);
            }
            network.addSilently(this, this.lastCapacityProvided, this.lastStressApplied);
        }
        super.initialize();
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.needsSpeedUpdate()) {
            this.attachKinetics();
        }
        super.func_73660_a();
        this.effects.tick();
        if (this.field_145850_b.field_72995_K) {
            this.cachedBoundingBox = null;
            return;
        }
        if (this.validationCountdown-- <= 0) {
            this.validationCountdown = (Integer)AllConfigs.SERVER.kinetics.kineticValidationFrequency.get();
            this.validateKinetics();
        }
        if (this.getFlickerScore() > 0) {
            this.flickerTally = this.getFlickerScore() - 1;
        }
        if (this.networkDirty) {
            if (this.hasNetwork()) {
                this.getOrCreateNetwork().updateNetwork();
            }
            this.networkDirty = false;
        }
    }

    private void validateKinetics() {
        if (this.hasSource()) {
            KineticTileEntity sourceTe;
            if (!this.hasNetwork()) {
                this.removeSource();
                return;
            }
            if (!this.field_145850_b.func_195588_v(this.source)) {
                return;
            }
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.source);
            KineticTileEntity kineticTileEntity = sourceTe = tileEntity instanceof KineticTileEntity ? (KineticTileEntity)tileEntity : null;
            if (sourceTe == null || sourceTe.speed == 0.0f) {
                this.removeSource();
                this.detachKinetics();
                return;
            }
            return;
        }
        if (this.speed != 0.0f && this.getGeneratedSpeed() == 0.0f) {
            this.speed = 0.0f;
        }
    }

    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        boolean overStressed;
        this.networkDirty = false;
        this.capacity = maxStress;
        this.stress = currentStress;
        this.networkSize = networkSize;
        boolean bl = overStressed = maxStress < currentStress && IRotate.StressImpact.isEnabled();
        if (overStressed != this.overStressed) {
            float prevSpeed = this.getSpeed();
            this.overStressed = overStressed;
            this.onSpeedChanged(prevSpeed);
            this.sendData();
        }
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = (float)AllConfigs.SERVER.kinetics.stressValues.getCapacityOf(this.getStressConfigKey());
        return capacity;
    }

    protected Block getStressConfigKey() {
        return this.func_195044_w().func_177230_c();
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)AllConfigs.SERVER.kinetics.stressValues.getImpactOf(this.getStressConfigKey());
        return impact;
    }

    public void onSpeedChanged(float previousSpeed) {
        boolean directionSwap;
        boolean fromOrToZero = previousSpeed == 0.0f != (this.getSpeed() == 0.0f);
        boolean bl = directionSwap = !fromOrToZero && Math.signum(previousSpeed) != Math.signum(this.getSpeed());
        if (fromOrToZero || directionSwap) {
            this.flickerTally = this.getFlickerScore() + 5;
        }
    }

    @Override
    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.hasNetwork()) {
                this.getOrCreateNetwork().remove(this);
            }
            this.detachKinetics();
        }
        super.func_145843_s();
    }

    @Override
    protected void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_74776_a("Speed", this.speed);
        if (this.needsSpeedUpdate()) {
            compound.func_74757_a("NeedsSpeedUpdate", true);
        }
        if (this.hasSource()) {
            compound.func_218657_a("Source", (INBT)NBTUtil.func_186859_a((BlockPos)this.source));
        }
        if (this.hasNetwork()) {
            CompoundNBT networkTag = new CompoundNBT();
            networkTag.func_74772_a("Id", this.network.longValue());
            networkTag.func_74776_a("Stress", this.stress);
            networkTag.func_74776_a("Capacity", this.capacity);
            networkTag.func_74768_a("Size", this.networkSize);
            if (this.lastStressApplied != 0.0f) {
                networkTag.func_74776_a("AddedStress", this.lastStressApplied);
            }
            if (this.lastCapacityProvided != 0.0f) {
                networkTag.func_74776_a("AddedCapacity", this.lastCapacityProvided);
            }
            compound.func_218657_a("Network", (INBT)networkTag);
        }
        super.write(compound, clientPacket);
    }

    public boolean needsSpeedUpdate() {
        return this.updateSpeed;
    }

    @Override
    protected void read(CompoundNBT compound, boolean clientPacket) {
        boolean overStressedBefore = this.overStressed;
        this.clearKineticInformation();
        if (this.wasMoved) {
            super.read(compound, clientPacket);
            return;
        }
        this.speed = compound.func_74760_g("Speed");
        if (compound.func_74764_b("Source")) {
            this.source = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("Source"));
        }
        if (compound.func_74764_b("Network")) {
            CompoundNBT networkTag = compound.func_74775_l("Network");
            this.network = networkTag.func_74763_f("Id");
            this.stress = networkTag.func_74760_g("Stress");
            this.capacity = networkTag.func_74760_g("Capacity");
            this.networkSize = networkTag.func_74762_e("Size");
            this.lastStressApplied = networkTag.func_74760_g("AddedStress");
            this.lastCapacityProvided = networkTag.func_74760_g("AddedCapacity");
            this.overStressed = this.capacity < this.stress && IRotate.StressImpact.isEnabled();
        }
        super.read(compound, clientPacket);
        if (clientPacket && overStressedBefore != this.overStressed && this.speed != 0.0f) {
            this.effects.triggerOverStressedEffect();
        }
        if (clientPacket) {
            FastRenderDispatcher.enqueueUpdate(this);
        }
    }

    public float getGeneratedSpeed() {
        return 0.0f;
    }

    public boolean isSource() {
        return this.getGeneratedSpeed() != 0.0f;
    }

    public float getSpeed() {
        if (this.overStressed) {
            return 0.0f;
        }
        return this.getTheoreticalSpeed();
    }

    public float getTheoreticalSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public void setSource(BlockPos source) {
        this.source = source;
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(source);
        if (!(tileEntity instanceof KineticTileEntity)) {
            this.removeSource();
            return;
        }
        KineticTileEntity sourceTe = (KineticTileEntity)tileEntity;
        this.setNetwork(sourceTe.network);
    }

    public void removeSource() {
        float prevSpeed = this.getSpeed();
        this.speed = 0.0f;
        this.source = null;
        this.setNetwork(null);
        this.onSpeedChanged(prevSpeed);
    }

    public void setNetwork(@Nullable Long networkIn) {
        if (this.network == networkIn) {
            return;
        }
        if (this.network != null) {
            this.getOrCreateNetwork().remove(this);
        }
        this.network = networkIn;
        if (networkIn == null) {
            return;
        }
        this.network = networkIn;
        KineticNetwork network = this.getOrCreateNetwork();
        network.initialized = true;
        network.add(this);
    }

    public KineticNetwork getOrCreateNetwork() {
        return Create.torquePropagator.getOrCreateNetworkFor(this);
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public void attachKinetics() {
        this.updateSpeed = false;
        RotationPropagator.handleAdded(this.field_145850_b, this.field_174879_c, this);
    }

    public void detachKinetics() {
        RotationPropagator.handleRemoved(this.field_145850_b, this.field_174879_c, this);
    }

    public boolean isSpeedRequirementFulfilled() {
        BlockState state = this.func_195044_w();
        if (!(this.func_195044_w().func_177230_c() instanceof IRotate)) {
            return true;
        }
        IRotate def = (IRotate)state.func_177230_c();
        IRotate.SpeedLevel minimumRequiredSpeedLevel = def.getMinimumRequiredSpeedLevel();
        if (minimumRequiredSpeedLevel == null) {
            return true;
        }
        if (minimumRequiredSpeedLevel == IRotate.SpeedLevel.MEDIUM) {
            return (double)Math.abs(this.getSpeed()) >= (Double)AllConfigs.SERVER.kinetics.mediumSpeed.get();
        }
        if (minimumRequiredSpeedLevel == IRotate.SpeedLevel.FAST) {
            return (double)Math.abs(this.getSpeed()) >= (Double)AllConfigs.SERVER.kinetics.fastSpeed.get();
        }
        return true;
    }

    public static void switchToBlockState(World world, BlockPos pos, BlockState state) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileEntityIn = world.func_175625_s(pos);
        BlockState currentState = world.func_180495_p(pos);
        boolean isKinetic = tileEntityIn instanceof KineticTileEntity;
        if (currentState == state) {
            return;
        }
        if (tileEntityIn == null || !isKinetic) {
            world.func_180501_a(pos, state, 3);
            return;
        }
        KineticTileEntity tileEntity = (KineticTileEntity)tileEntityIn;
        if (state.func_177230_c() instanceof KineticBlock && !((KineticBlock)state.func_177230_c()).areStatesKineticallyEquivalent(currentState, state)) {
            if (tileEntity.hasNetwork()) {
                tileEntity.getOrCreateNetwork().remove(tileEntity);
            }
            tileEntity.detachKinetics();
            tileEntity.removeSource();
        }
        world.func_180501_a(pos, state, 3);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    public boolean hasFastRenderer() {
        return true;
    }

    @Override
    public boolean addToTooltip(List<String> tooltip, boolean isPlayerSneaking) {
        boolean notFastEnough;
        boolean bl = notFastEnough = !this.isSpeedRequirementFulfilled() && this.getSpeed() != 0.0f;
        if (this.overStressed && ((Boolean)AllConfigs.CLIENT.enableOverstressedTooltip.get()).booleanValue()) {
            tooltip.add("    " + TextFormatting.GOLD + Lang.translate("gui.stressometer.overstressed", new Object[0]));
            String hint = Lang.translate("gui.contraptions.network_overstressed", I18n.func_135052_a((String)this.func_195044_w().func_177230_c().func_149739_a(), (Object[])new Object[0]));
            List<String> cutString = TooltipHelper.cutString("    " + hint, TextFormatting.GRAY, TextFormatting.WHITE);
            for (int i = 0; i < cutString.size(); ++i) {
                tooltip.add((i == 0 ? "" : "    ") + cutString.get(i));
            }
            return true;
        }
        if (notFastEnough) {
            tooltip.add("    " + TextFormatting.GOLD + Lang.translate("tooltip.speedRequirement", new Object[0]));
            String hint = Lang.translate("gui.contraptions.not_fast_enough", I18n.func_135052_a((String)this.func_195044_w().func_177230_c().func_149739_a(), (Object[])new Object[0]));
            List<String> cutString = TooltipHelper.cutString("    " + hint, TextFormatting.GRAY, TextFormatting.WHITE);
            for (int i = 0; i < cutString.size(); ++i) {
                tooltip.add((i == 0 ? "" : "    ") + cutString.get(i));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addToGoggleTooltip(List<String> tooltip, boolean isPlayerSneaking) {
        boolean added = false;
        float stressAtBase = this.calculateStressApplied();
        if (this.calculateStressApplied() != 0.0f && IRotate.StressImpact.isEnabled()) {
            tooltip.add("    " + Lang.translate("gui.goggles.kinetic_stats", new Object[0]));
            tooltip.add("    " + TextFormatting.GRAY + Lang.translate("tooltip.stressImpact", new Object[0]));
            float stressTotal = stressAtBase * Math.abs(this.getTheoreticalSpeed());
            String stressString = "    %s%s" + Lang.translate("generic.unit.stress", new Object[0]) + " " + TextFormatting.DARK_GRAY + "%s";
            tooltip.add(" " + String.format(stressString, TextFormatting.AQUA, IHaveGoggleInformation.format(stressTotal), Lang.translate("gui.goggles.at_current_speed", new Object[0])));
            added = true;
        }
        return added;
    }

    public void clearKineticInformation() {
        this.speed = 0.0f;
        this.source = null;
        this.network = null;
        this.overStressed = false;
        this.stress = 0.0f;
        this.capacity = 0.0f;
        this.lastStressApplied = 0.0f;
        this.lastCapacityProvided = 0.0f;
    }

    public void warnOfMovement() {
        this.wasMoved = true;
    }

    public int getFlickerScore() {
        return this.flickerTally;
    }

    public static float convertToDirection(float axisSpeed, Direction d) {
        return d.func_176743_c() == Direction.AxisDirection.POSITIVE ? axisSpeed : -axisSpeed;
    }

    public boolean isOverStressed() {
        return this.overStressed;
    }

    public float propagateRotationTo(KineticTileEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        return 0.0f;
    }

    public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
        if (!this.canPropagateDiagonally(block, state)) {
            return neighbours;
        }
        Direction.Axis axis = block.getRotationAxis(state);
        BlockPos.func_218281_b((BlockPos)new BlockPos(-1, -1, -1), (BlockPos)new BlockPos(1, 1, 1)).forEach(offset -> {
            if (axis.func_196052_a(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p()) != 0) {
                return;
            }
            if (offset.func_218140_a(0.0, 0.0, 0.0, false) != BlockPos.field_177992_a.func_218140_a(1.0, 1.0, 0.0, false)) {
                return;
            }
            neighbours.add(this.field_174879_c.func_177971_a((Vec3i)offset));
        });
        return neighbours;
    }

    public boolean isCustomConnection(KineticTileEntity other, BlockState state, BlockState otherState) {
        return false;
    }

    protected boolean canPropagateDiagonally(IRotate block, BlockState state) {
        return ICogWheel.isSmallCog(state);
    }

    public void requestModelDataUpdate() {
        super.requestModelDataUpdate();
        if (!this.field_145846_f) {
            FastRenderDispatcher.enqueueUpdate(this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.cachedBoundingBox == null) {
            this.cachedBoundingBox = this.makeRenderBoundingBox();
        }
        return this.cachedBoundingBox;
    }

    protected AxisAlignedBB makeRenderBoundingBox() {
        return super.getRenderBoundingBox();
    }
}

