/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.components.actors.HarvesterBlock;
import com.simibubi.create.content.contraptions.components.actors.HarvesterTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class HarvesterRenderer
extends SafeTileEntityRenderer<HarvesterTileEntity> {
    public HarvesterRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(HarvesterTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        BlockState blockState = te.func_195044_w();
        SuperByteBuffer superBuffer = AllBlockPartials.HARVESTER_BLADE.renderOn(blockState);
        HarvesterRenderer.transform(te.func_145831_w(), (Direction)blockState.func_177229_b((IProperty)HarvesterBlock.field_185512_D), superBuffer, te.manuallyAnimatedSpeed);
        superBuffer.light(light).renderInto(ms, buffer.getBuffer(RenderType.func_228641_d_()));
    }

    public static void renderInContraption(MovementContext context, MatrixStack ms, MatrixStack msLocal, IRenderTypeBuffer buffers) {
        float speed;
        BlockState blockState = context.state;
        Direction facing = (Direction)blockState.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
        SuperByteBuffer superBuffer = AllBlockPartials.HARVESTER_BLADE.renderOn(blockState);
        float f = speed = !VecHelper.isVecPointingTowards(context.relativeMotion, facing.func_176734_d()) ? context.getAnimationSpeed() : 0.0f;
        if (context.contraption.stalled) {
            speed = 0.0f;
        }
        HarvesterRenderer.transform(context.world, facing, superBuffer, speed);
        superBuffer.light(msLocal.func_227866_c_().func_227870_a_(), ContraptionRenderDispatcher.getLightOnContraption(context)).renderInto(ms, buffers.getBuffer(RenderType.func_228641_d_()));
    }

    public static void transform(World world, Direction facing, SuperByteBuffer superBuffer, float speed) {
        float originOffset = 0.0625f;
        Vec3d rotOffset = new Vec3d(0.0, (double)(-2.0f * originOffset), (double)originOffset).func_178787_e(VecHelper.getCenterOf((Vec3i)BlockPos.field_177992_a));
        float time = AnimationTickHolder.getRenderTime((IWorld)world) / 20.0f;
        float angle = time * speed % 360.0f;
        superBuffer.rotateCentered(Direction.UP, AngleHelper.rad(AngleHelper.horizontalAngle(facing))).translate(rotOffset.field_72450_a, rotOffset.field_72448_b, rotOffset.field_72449_c).rotate(Direction.WEST, AngleHelper.rad(angle)).translate(-rotOffset.field_72450_a, -rotOffset.field_72448_b, -rotOffset.field_72449_c);
    }
}

