/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crafter;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.crafter.ConnectedInputHandler;
import com.simibubi.create.content.contraptions.components.crafter.CrafterHelper;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterTileEntity;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pointing;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class MechanicalCrafterBlock
extends HorizontalKineticBlock
implements ITE<MechanicalCrafterTileEntity>,
ICogWheel {
    public static final EnumProperty<Pointing> POINTING = EnumProperty.func_177709_a((String)"pointing", Pointing.class);

    public MechanicalCrafterBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(POINTING, (Comparable)((Object)Pointing.UP)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a((StateContainer.Builder<Block, BlockState>)builder.func_206894_a(new IProperty[]{POINTING}));
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.MECHANICAL_CRAFTER.create();
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176740_k();
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction face = context.func_196000_l();
        BlockPos placedOnPos = context.func_195995_a().func_177972_a(face.func_176734_d());
        BlockState blockState = context.func_195991_k().func_180495_p(placedOnPos);
        if (blockState.func_177230_c() != this || context.func_195999_j() != null && context.func_195999_j().func_225608_bj_()) {
            BlockState stateForPlacement = super.func_196258_a(context);
            Direction direction = (Direction)stateForPlacement.func_177229_b(HORIZONTAL_FACING);
            if (direction != face) {
                stateForPlacement = (BlockState)stateForPlacement.func_206870_a(POINTING, (Comparable)((Object)MechanicalCrafterBlock.pointingFromFacing(face, direction)));
            }
            return stateForPlacement;
        }
        Direction otherFacing = (Direction)blockState.func_177229_b(HORIZONTAL_FACING);
        Pointing pointing = MechanicalCrafterBlock.pointingFromFacing(face, otherFacing);
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(HORIZONTAL_FACING, (Comparable)otherFacing)).func_206870_a(POINTING, (Comparable)((Object)pointing));
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        MechanicalCrafterTileEntity crafter;
        if (state.func_177230_c() == newState.func_177230_c() && MechanicalCrafterBlock.getTargetDirection(state) != MechanicalCrafterBlock.getTargetDirection(newState) && (crafter = CrafterHelper.getCrafter((ILightReader)worldIn, pos)) != null) {
            crafter.blockChanged();
        }
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
            crafter = CrafterHelper.getCrafter((ILightReader)worldIn, pos);
            if (crafter != null) {
                if (crafter.covered) {
                    Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)AllItems.CRAFTER_SLOT_COVER.asStack());
                }
                crafter.ejectWholeGrid();
            }
            for (Direction direction : Iterate.directions) {
                if (direction.func_176740_k() == ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176740_k()) continue;
                BlockPos otherPos = pos.func_177972_a(direction);
                ConnectedInputHandler.ConnectedInput thisInput = CrafterHelper.getInput((ILightReader)worldIn, pos);
                ConnectedInputHandler.ConnectedInput otherInput = CrafterHelper.getInput((ILightReader)worldIn, otherPos);
                if (thisInput == null || otherInput == null || !pos.func_177971_a((Vec3i)thisInput.data.get(0)).equals((Object)otherPos.func_177971_a((Vec3i)otherInput.data.get(0)))) continue;
                ConnectedInputHandler.toggleConnection(worldIn, pos, otherPos);
            }
            worldIn.func_175713_t(pos);
        }
    }

    public static Pointing pointingFromFacing(Direction pointingFace, Direction blockFacing) {
        Pointing pointing;
        boolean positive = blockFacing.func_176743_c() == Direction.AxisDirection.POSITIVE;
        Pointing pointing2 = pointing = pointingFace == Direction.DOWN ? Pointing.UP : Pointing.DOWN;
        if (pointingFace == Direction.EAST) {
            Pointing pointing3 = pointing = positive ? Pointing.LEFT : Pointing.RIGHT;
        }
        if (pointingFace == Direction.WEST) {
            Pointing pointing4 = pointing = positive ? Pointing.RIGHT : Pointing.LEFT;
        }
        if (pointingFace == Direction.NORTH) {
            Pointing pointing5 = pointing = positive ? Pointing.LEFT : Pointing.RIGHT;
        }
        if (pointingFace == Direction.SOUTH) {
            pointing = positive ? Pointing.RIGHT : Pointing.LEFT;
        }
        return pointing;
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        if (context.func_196000_l() == state.func_177229_b(HORIZONTAL_FACING)) {
            if (!context.func_195991_k().field_72995_K) {
                KineticTileEntity.switchToBlockState(context.func_195991_k(), context.func_195995_a(), (BlockState)state.func_177231_a(POINTING));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(handIn);
        boolean isHand = heldItem.func_190926_b() && handIn == Hand.MAIN_HAND;
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof MechanicalCrafterTileEntity)) {
            return ActionResultType.PASS;
        }
        MechanicalCrafterTileEntity crafter = (MechanicalCrafterTileEntity)te;
        boolean wrenched = AllItems.WRENCH.isIn(heldItem);
        if (AllBlocks.MECHANICAL_ARM.isIn(heldItem)) {
            return ActionResultType.PASS;
        }
        if (hit.func_216354_b() == state.func_177229_b(HORIZONTAL_FACING)) {
            if (crafter.phase != MechanicalCrafterTileEntity.Phase.IDLE && !wrenched) {
                crafter.ejectWholeGrid();
                return ActionResultType.SUCCESS;
            }
            if (crafter.phase == MechanicalCrafterTileEntity.Phase.IDLE && !isHand && !wrenched) {
                if (worldIn.field_72995_K) {
                    return ActionResultType.SUCCESS;
                }
                if (AllItems.CRAFTER_SLOT_COVER.isIn(heldItem)) {
                    if (crafter.covered) {
                        return ActionResultType.PASS;
                    }
                    if (!crafter.inventory.func_191420_l()) {
                        return ActionResultType.PASS;
                    }
                    crafter.covered = true;
                    crafter.func_70296_d();
                    crafter.sendData();
                    if (!player.func_184812_l_()) {
                        heldItem.func_190918_g(1);
                    }
                    return ActionResultType.SUCCESS;
                }
                LazyOptional capability = crafter.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                if (!capability.isPresent()) {
                    return ActionResultType.PASS;
                }
                ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)capability.orElse((Object)new ItemStackHandler())), (ItemStack)heldItem.func_77946_l(), (boolean)false);
                if (remainder.func_190916_E() != heldItem.func_190916_E()) {
                    player.func_184611_a(handIn, remainder);
                }
                return ActionResultType.SUCCESS;
            }
            ItemStack inSlot = crafter.getInventory().func_70301_a(0);
            if (inSlot.func_190926_b()) {
                if (crafter.covered && !wrenched) {
                    if (worldIn.field_72995_K) {
                        return ActionResultType.SUCCESS;
                    }
                    crafter.covered = false;
                    crafter.func_70296_d();
                    crafter.sendData();
                    if (!player.func_184812_l_()) {
                        player.field_71071_by.func_191975_a(worldIn, AllItems.CRAFTER_SLOT_COVER.asStack());
                    }
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.PASS;
            }
            if (!isHand && !ItemHandlerHelper.canItemStacksStack((ItemStack)heldItem, (ItemStack)inSlot)) {
                return ActionResultType.PASS;
            }
            if (worldIn.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            player.field_71071_by.func_191975_a(worldIn, inSlot);
            crafter.getInventory().setStackInSlot(0, ItemStack.field_190927_a);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        InvManipulationBehaviour behaviour = TileEntityBehaviour.get((IBlockReader)worldIn, pos, InvManipulationBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.onNeighborChanged(fromPos);
        }
    }

    @Override
    public float getParticleTargetRadius() {
        return 0.85f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 0.75f;
    }

    public static Direction getTargetDirection(BlockState state) {
        if (!AllBlocks.MECHANICAL_CRAFTER.has(state)) {
            return Direction.UP;
        }
        Direction facing = (Direction)state.func_177229_b(HORIZONTAL_FACING);
        Pointing point = (Pointing)((Object)state.func_177229_b(POINTING));
        Vec3d targetVec = new Vec3d(0.0, 1.0, 0.0);
        targetVec = VecHelper.rotate(targetVec, -point.getXRotation(), Direction.Axis.Z);
        targetVec = VecHelper.rotate(targetVec, AngleHelper.horizontalAngle(facing), Direction.Axis.Y);
        return Direction.func_210769_a((double)targetVec.field_72450_a, (double)targetVec.field_72448_b, (double)targetVec.field_72449_c);
    }

    public static boolean isValidTarget(World world, BlockPos targetPos, BlockState crafterState) {
        BlockState targetState = world.func_180495_p(targetPos);
        if (!world.func_195588_v(targetPos)) {
            return false;
        }
        if (!AllBlocks.MECHANICAL_CRAFTER.has(targetState)) {
            return false;
        }
        if (crafterState.func_177229_b(HORIZONTAL_FACING) != targetState.func_177229_b(HORIZONTAL_FACING)) {
            return false;
        }
        return Math.abs(((Pointing)((Object)crafterState.func_177229_b(POINTING))).getXRotation() - ((Pointing)((Object)targetState.func_177229_b(POINTING))).getXRotation()) != 180;
    }

    @Override
    public Class<MechanicalCrafterTileEntity> getTileEntityClass() {
        return MechanicalCrafterTileEntity.class;
    }
}

