/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crank;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.SingleRotatingInstance;
import com.simibubi.create.content.contraptions.components.crank.HandCrankBlock;
import com.simibubi.create.content.contraptions.components.crank.HandCrankTileEntity;
import com.simibubi.create.foundation.render.backend.core.ModelData;
import com.simibubi.create.foundation.render.backend.instancing.IDynamicInstance;
import com.simibubi.create.foundation.render.backend.instancing.InstancedModel;
import com.simibubi.create.foundation.render.backend.instancing.InstancedTileRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.MatrixStacker;
import net.minecraft.block.Block;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3i;

public class HandCrankInstance
extends SingleRotatingInstance
implements IDynamicInstance {
    private final HandCrankTileEntity tile;
    private ModelData crank;
    private Direction facing;

    public HandCrankInstance(InstancedTileRenderer<?> modelManager, HandCrankTileEntity tile) {
        super(modelManager, tile);
        this.tile = tile;
        Block block = this.blockState.func_177230_c();
        AllBlockPartials renderedHandle = null;
        if (block instanceof HandCrankBlock) {
            renderedHandle = ((HandCrankBlock)block).getRenderedHandle();
        }
        if (renderedHandle == null) {
            return;
        }
        this.facing = (Direction)this.blockState.func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        InstancedModel<ModelData> model = renderedHandle.renderOnDirectionalSouthModel(modelManager, this.blockState, this.facing.func_176734_d());
        this.crank = model.createInstance();
        this.rotateCrank();
    }

    @Override
    public void beginFrame() {
        if (this.crank == null) {
            return;
        }
        this.rotateCrank();
    }

    private void rotateCrank() {
        Direction.Axis axis = this.facing.func_176740_k();
        float angle = (this.tile.independentAngle + AnimationTickHolder.getPartialTicks() * this.tile.chasingVelocity) / 360.0f;
        MatrixStack ms = new MatrixStack();
        MatrixStacker.of(ms).translate((Vec3i)this.getInstancePosition()).centre().rotate(Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis), angle).unCentre();
        this.crank.setTransform(ms);
    }

    @Override
    public void remove() {
        super.remove();
        if (this.crank != null) {
            this.crank.delete();
        }
    }

    @Override
    public void updateLight() {
        super.updateLight();
        if (this.crank != null) {
            this.relight(this.pos, this.crank);
        }
    }
}

