/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crusher;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.contraptions.components.crusher.CrushingWheelControllerBlock;
import com.simibubi.create.content.contraptions.components.crusher.CrushingWheelTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class CrushingWheelBlock
extends RotatedPillarKineticBlock
implements ITE<CrushingWheelTileEntity> {
    public CrushingWheelBlock(Block.Properties properties) {
        super(properties);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.CRUSHING_WHEEL.create();
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.func_177229_b((IProperty)AXIS);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AllShapes.CRUSHING_WHEEL_COLLISION_SHAPE;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        for (Direction d : Iterate.directions) {
            if (d.func_176740_k() == state.func_177229_b((IProperty)AXIS) || !AllBlocks.CRUSHING_WHEEL_CONTROLLER.has(worldIn.func_180495_p(pos.func_177972_a(d)))) continue;
            worldIn.func_175656_a(pos.func_177972_a(d), Blocks.field_150350_a.func_176223_P());
        }
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
            worldIn.func_175713_t(pos);
        }
    }

    public void updateControllers(BlockState state, World world, BlockPos pos, Direction side) {
        if (side.func_176740_k() == state.func_177229_b((IProperty)AXIS)) {
            return;
        }
        if (world == null) {
            return;
        }
        BlockPos controllerPos = pos.func_177972_a(side);
        BlockPos otherWheelPos = pos.func_177967_a(side, 2);
        boolean controllerExists = AllBlocks.CRUSHING_WHEEL_CONTROLLER.has(world.func_180495_p(controllerPos));
        boolean controllerIsValid = controllerExists && (Boolean)world.func_180495_p(controllerPos).func_177229_b((IProperty)CrushingWheelControllerBlock.VALID) != false;
        Direction controllerOldDirection = controllerExists ? (Direction)world.func_180495_p(controllerPos).func_177229_b((IProperty)CrushingWheelControllerBlock.field_176387_N) : null;
        boolean controllerShouldExist = false;
        boolean controllerShouldBeValid = false;
        Direction controllerNewDirection = Direction.DOWN;
        BlockState otherState = world.func_180495_p(otherWheelPos);
        if (AllBlocks.CRUSHING_WHEEL.has(otherState)) {
            controllerShouldExist = true;
            try {
                CrushingWheelTileEntity te = (CrushingWheelTileEntity)this.getTileEntity((IBlockReader)world, pos);
                CrushingWheelTileEntity otherTe = (CrushingWheelTileEntity)this.getTileEntity((IBlockReader)world, otherWheelPos);
                if (te != null && otherTe != null && te.getSpeed() > 0.0f != otherTe.getSpeed() > 0.0f && te.getSpeed() != 0.0f) {
                    Direction.Axis wheelAxis = (Direction.Axis)state.func_177229_b((IProperty)AXIS);
                    Direction.Axis sideAxis = side.func_176740_k();
                    int controllerADO = Math.round(Math.signum(te.getSpeed())) * side.func_176743_c().func_179524_a();
                    Vec3d controllerDirVec = new Vec3d(wheelAxis == Direction.Axis.X ? 1.0 : 0.0, wheelAxis == Direction.Axis.Y ? 1.0 : 0.0, wheelAxis == Direction.Axis.Z ? 1.0 : 0.0).func_72431_c(new Vec3d(sideAxis == Direction.Axis.X ? 1.0 : 0.0, sideAxis == Direction.Axis.Y ? 1.0 : 0.0, sideAxis == Direction.Axis.Z ? 1.0 : 0.0));
                    controllerNewDirection = Direction.func_210769_a((double)(controllerDirVec.field_72450_a * (double)controllerADO), (double)(controllerDirVec.field_72448_b * (double)controllerADO), (double)(controllerDirVec.field_72449_c * (double)controllerADO));
                    controllerShouldBeValid = true;
                }
                if (otherState.func_177229_b((IProperty)AXIS) != state.func_177229_b((IProperty)AXIS)) {
                    controllerShouldExist = false;
                }
            }
            catch (ITE.TileEntityException e) {
                controllerShouldExist = false;
            }
        }
        if (!controllerShouldExist) {
            if (controllerExists) {
                world.func_175656_a(controllerPos, Blocks.field_150350_a.func_176223_P());
            }
            return;
        }
        if (!controllerExists) {
            if (!world.func_180495_p(controllerPos).func_185904_a().func_76222_j()) {
                return;
            }
            world.func_175656_a(controllerPos, (BlockState)((BlockState)AllBlocks.CRUSHING_WHEEL_CONTROLLER.getDefaultState().func_206870_a((IProperty)CrushingWheelControllerBlock.VALID, (Comparable)Boolean.valueOf(controllerShouldBeValid))).func_206870_a((IProperty)CrushingWheelControllerBlock.field_176387_N, (Comparable)controllerNewDirection));
        } else if (controllerIsValid != controllerShouldBeValid || controllerOldDirection != controllerNewDirection) {
            world.func_175656_a(controllerPos, (BlockState)((BlockState)world.func_180495_p(controllerPos).func_206870_a((IProperty)CrushingWheelControllerBlock.VALID, (Comparable)Boolean.valueOf(controllerShouldBeValid))).func_206870_a((IProperty)CrushingWheelControllerBlock.field_176387_N, (Comparable)controllerNewDirection));
        }
        ((CrushingWheelControllerBlock)AllBlocks.CRUSHING_WHEEL_CONTROLLER.get()).updateSpeed(world.func_180495_p(controllerPos), world, controllerPos);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        try {
            CrushingWheelTileEntity te = (CrushingWheelTileEntity)this.getTileEntity((IBlockReader)worldIn, pos);
            if (entityIn.func_226278_cu_() < (double)((float)pos.func_177956_o() + 1.25f) || !entityIn.field_70122_E) {
                return;
            }
            double x = 0.0;
            double z = 0.0;
            if (state.func_177229_b((IProperty)AXIS) == Direction.Axis.X) {
                z = te.getSpeed() / 20.0f;
                x += ((double)((float)pos.func_177958_n() + 0.5f) - entityIn.func_226277_ct_()) * (double)0.1f;
            }
            if (state.func_177229_b((IProperty)AXIS) == Direction.Axis.Z) {
                x = te.getSpeed() / -20.0f;
                z += ((double)((float)pos.func_177952_p() + 0.5f) - entityIn.func_226281_cx_()) * (double)0.1f;
            }
            entityIn.func_213317_d(entityIn.func_213322_ci().func_72441_c(x, 0.0, z));
        }
        catch (ITE.TileEntityException tileEntityException) {
            // empty catch block
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        for (Direction direction : Iterate.directions) {
            BlockPos neighbourPos = pos.func_177972_a(direction);
            BlockState neighbourState = worldIn.func_180495_p(neighbourPos);
            Direction.Axis stateAxis = (Direction.Axis)state.func_177229_b((IProperty)AXIS);
            if (AllBlocks.CRUSHING_WHEEL_CONTROLLER.has(neighbourState) && direction.func_176740_k() != stateAxis) {
                return false;
            }
            if (!AllBlocks.CRUSHING_WHEEL.has(neighbourState) || neighbourState.func_177229_b((IProperty)AXIS) == stateAxis && stateAxis == direction.func_176740_k()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasShaftTowards(IWorldReader world, BlockPos pos, BlockState state, Direction face) {
        return face.func_176740_k() == state.func_177229_b((IProperty)AXIS);
    }

    @Override
    public float getParticleTargetRadius() {
        return 1.125f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 1.0f;
    }

    @Override
    public Class<CrushingWheelTileEntity> getTileEntityClass() {
        return CrushingWheelTileEntity.class;
    }
}

