/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticRenderMaterials;
import com.simibubi.create.content.contraptions.base.KineticTileInstance;
import com.simibubi.create.content.contraptions.base.RotatingData;
import com.simibubi.create.content.contraptions.components.deployer.DeployerRenderer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ActorInstance;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionKineticRenderer;
import com.simibubi.create.foundation.render.backend.core.ModelData;
import com.simibubi.create.foundation.render.backend.instancing.RenderMaterial;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class DeployerActorInstance
extends ActorInstance {
    Direction facing;
    boolean stationaryTimer;
    float yRot;
    float zRot;
    float zRotPole;
    ModelData pole;
    ModelData hand;
    RotatingData shaft;

    public DeployerActorInstance(ContraptionKineticRenderer modelManager, MovementContext context) {
        super(modelManager, context);
        RenderMaterial mat = modelManager.getTransformMaterial();
        BlockState state = context.state;
        DeployerTileEntity.Mode mode = NBTHelper.readEnum(context.tileData, "Mode", DeployerTileEntity.Mode.class);
        AllBlockPartials handPose = DeployerRenderer.getHandPose(mode);
        this.stationaryTimer = context.data.func_74764_b("StationaryTimer");
        this.facing = (Direction)state.func_177229_b((IProperty)DirectionalKineticBlock.FACING);
        boolean rotatePole = (Boolean)state.func_177229_b((IProperty)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ this.facing.func_176740_k() == Direction.Axis.Z;
        this.yRot = AngleHelper.horizontalAngle(this.facing);
        this.zRot = this.facing == Direction.UP ? 270.0f : (this.facing == Direction.DOWN ? 90.0f : 0.0f);
        this.zRotPole = rotatePole ? 90.0f : 0.0f;
        this.pole = mat.getModel(AllBlockPartials.DEPLOYER_POLE, state).createInstance();
        this.hand = mat.getModel(handPose, state).createInstance();
        Direction.Axis axis = ((IRotate)state.func_177230_c()).getRotationAxis(state);
        this.shaft = modelManager.getMaterial(KineticRenderMaterials.ROTATING).getModel(KineticTileInstance.shaft(axis)).createInstance();
        int blockLight = this.localBlockLight();
        this.shaft.setRotationAxis(axis).setPosition(context.localPos).setBlockLight(blockLight);
        this.pole.setBlockLight(blockLight);
        this.hand.setBlockLight(blockLight);
    }

    @Override
    public void beginFrame() {
        double factor;
        if (this.context.contraption.stalled || this.context.position == null || this.context.data.func_74764_b("StationaryTimer")) {
            factor = MathHelper.func_76126_a((float)(AnimationTickHolder.getRenderTime() * 0.5f)) * 0.25f + 0.25f;
        } else {
            Vec3d center = VecHelper.getCenterOf((Vec3i)new BlockPos(this.context.position));
            double distance = this.context.position.func_72438_d(center);
            double nextDistance = this.context.position.func_178787_e(this.context.motion).func_72438_d(center);
            factor = 0.5 - MathHelper.func_151237_a((double)MathHelper.func_219803_d((double)AnimationTickHolder.getPartialTicks(), (double)distance, (double)nextDistance), (double)0.0, (double)1.0);
        }
        Vec3d offset = new Vec3d(this.facing.func_176730_m()).func_186678_a(factor);
        MatrixStack ms = new MatrixStack();
        MatrixStacker msr = MatrixStacker.of(ms);
        msr.translate((Vec3i)this.context.localPos).translate(offset);
        DeployerActorInstance.transformModel(msr, this.pole, this.hand, this.yRot, this.zRot, this.zRotPole);
    }

    static void transformModel(MatrixStacker msr, ModelData pole, ModelData hand, float yRot, float zRot, float zRotPole) {
        msr.centre();
        msr.rotate(Direction.SOUTH, (float)((double)(zRot / 180.0f) * Math.PI));
        msr.rotate(Direction.UP, (float)((double)(yRot / 180.0f) * Math.PI));
        msr.push();
        msr.rotate(Direction.SOUTH, (float)((double)(zRotPole / 180.0f) * Math.PI));
        msr.unCentre();
        pole.setTransform(msr.unwrap());
        msr.pop();
        msr.unCentre();
        hand.setTransform(msr.unwrap());
    }
}

