/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.backend.FastRenderDispatcher;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class DeployerRenderer
extends SafeTileEntityRenderer<DeployerTileEntity> {
    public DeployerRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(DeployerTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        this.renderItem(te, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnTileEntity(te, partialTicks, ms, buffer, light, overlay);
        if (FastRenderDispatcher.available(te.func_145831_w())) {
            return;
        }
        this.renderComponents(te, partialTicks, ms, buffer, light, overlay);
    }

    protected void renderItem(DeployerTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        boolean isBlockItem;
        if (te.heldItem.func_190926_b()) {
            return;
        }
        BlockState deployerState = te.func_195044_w();
        Vec3d offset = this.getHandOffset(te, partialTicks, deployerState).func_178787_e(VecHelper.getCenterOf((Vec3i)BlockPos.field_177992_a));
        ms.func_227860_a_();
        ms.func_227861_a_(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
        Direction facing = (Direction)deployerState.func_177229_b((IProperty)DirectionalKineticBlock.FACING);
        boolean punching = te.mode == DeployerTileEntity.Mode.PUNCH;
        float yRot = AngleHelper.horizontalAngle(facing) + 180.0f;
        float zRot = facing == Direction.UP ? 90.0f : (facing == Direction.DOWN ? 270.0f : 0.0f);
        boolean displayMode = facing == Direction.UP && te.getSpeed() == 0.0f && !punching;
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(yRot));
        if (!displayMode) {
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(zRot));
            ms.func_227861_a_(0.0, 0.0, -0.6875);
        }
        if (punching) {
            ms.func_227861_a_(0.0, 0.125, -0.0625);
        }
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        ItemCameraTransforms.TransformType transform = ItemCameraTransforms.TransformType.NONE;
        boolean bl = isBlockItem = te.heldItem.func_77973_b() instanceof BlockItem && itemRenderer.func_184393_a(te.heldItem, (World)Minecraft.func_71410_x().field_71441_e, null).func_177556_c();
        if (displayMode) {
            float scale = isBlockItem ? 1.25f : 1.0f;
            ms.func_227861_a_(0.0, isBlockItem ? 0.5625 : 0.6875, 0.0);
            ms.func_227862_a_(scale, scale, scale);
            transform = ItemCameraTransforms.TransformType.GROUND;
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(AnimationTickHolder.getRenderTime((IWorld)te.func_145831_w())));
        } else {
            float scale = punching ? 0.75f : (isBlockItem ? 0.734375f : 0.5f);
            ms.func_227862_a_(scale, scale, scale);
            transform = punching ? ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIXED;
        }
        itemRenderer.func_229110_a_(te.heldItem, transform, light, overlay, ms, buffer);
        ms.func_227865_b_();
    }

    protected void renderComponents(DeployerTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        IVertexBuilder vb = buffer.getBuffer(RenderType.func_228639_c_());
        if (!FastRenderDispatcher.available(te.func_145831_w())) {
            KineticTileEntityRenderer.renderRotatingKineticBlock(te, this.getRenderedBlockState(te), ms, vb, light);
        }
        BlockState blockState = te.func_195044_w();
        BlockPos pos = te.func_174877_v();
        Vec3d offset = this.getHandOffset(te, partialTicks, blockState);
        SuperByteBuffer pole = AllBlockPartials.DEPLOYER_POLE.renderOn(blockState);
        SuperByteBuffer hand = te.getHandPose().renderOn(blockState);
        DeployerRenderer.transform(te.func_145831_w(), pole.translate(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c), blockState, pos, true).renderInto(ms, vb);
        DeployerRenderer.transform(te.func_145831_w(), hand.translate(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c), blockState, pos, false).renderInto(ms, vb);
    }

    protected Vec3d getHandOffset(DeployerTileEntity te, float partialTicks, BlockState blockState) {
        float distance = te.getHandOffset(partialTicks);
        Vec3d offset = new Vec3d(((Direction)blockState.func_177229_b((IProperty)DirectionalKineticBlock.FACING)).func_176730_m()).func_186678_a((double)distance);
        return offset;
    }

    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        return KineticTileEntityRenderer.shaft(KineticTileEntityRenderer.getRotationAxisOf(te));
    }

    private static SuperByteBuffer transform(World world, SuperByteBuffer buffer, BlockState deployerState, BlockPos pos, boolean axisDirectionMatters) {
        Direction facing = (Direction)deployerState.func_177229_b((IProperty)DirectionalKineticBlock.FACING);
        float zRotLast = axisDirectionMatters && (Boolean)deployerState.func_177229_b((IProperty)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ facing.func_176740_k() == Direction.Axis.Z ? 90.0f : 0.0f;
        float yRot = AngleHelper.horizontalAngle(facing);
        float zRot = facing == Direction.UP ? 270.0f : (facing == Direction.DOWN ? 90.0f : 0.0f);
        buffer.rotateCentered(Direction.SOUTH, (float)((double)(zRot / 180.0f) * Math.PI));
        buffer.rotateCentered(Direction.UP, (float)((double)(yRot / 180.0f) * Math.PI));
        buffer.rotateCentered(Direction.SOUTH, (float)((double)(zRotLast / 180.0f) * Math.PI));
        buffer.light(WorldRenderer.func_228420_a_((ILightReader)world, (BlockState)deployerState, (BlockPos)pos));
        return buffer;
    }

    public static void renderInContraption(MovementContext context, MatrixStack ms, MatrixStack msLocal, IRenderTypeBuffer buffer) {
        double factor;
        MatrixStack[] matrixStacks = new MatrixStack[]{ms, msLocal};
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228639_c_());
        BlockState blockState = context.state;
        BlockPos pos = BlockPos.field_177992_a;
        DeployerTileEntity.Mode mode = NBTHelper.readEnum(context.tileData, "Mode", DeployerTileEntity.Mode.class);
        World world = context.world;
        AllBlockPartials handPose = DeployerRenderer.getHandPose(mode);
        SuperByteBuffer pole = AllBlockPartials.DEPLOYER_POLE.renderOn(blockState);
        SuperByteBuffer hand = handPose.renderOn(blockState);
        pole = DeployerRenderer.transform(world, pole, blockState, pos, true);
        hand = DeployerRenderer.transform(world, hand, blockState, pos, false);
        if (context.contraption.stalled || context.position == null || context.data.func_74764_b("StationaryTimer")) {
            factor = MathHelper.func_76126_a((float)(AnimationTickHolder.getRenderTime() * 0.5f)) * 0.25f + 0.25f;
        } else {
            Vec3d center = VecHelper.getCenterOf((Vec3i)new BlockPos(context.position));
            double distance = context.position.func_72438_d(center);
            double nextDistance = context.position.func_178787_e(context.motion).func_72438_d(center);
            factor = 0.5 - MathHelper.func_151237_a((double)MathHelper.func_219803_d((double)AnimationTickHolder.getPartialTicks(), (double)distance, (double)nextDistance), (double)0.0, (double)1.0);
        }
        Vec3d offset = new Vec3d(((Direction)blockState.func_177229_b((IProperty)DirectionalKineticBlock.FACING)).func_176730_m()).func_186678_a(factor);
        Matrix4f lighting = msLocal.func_227866_c_().func_227870_a_();
        for (MatrixStack m : matrixStacks) {
            m.func_227861_a_(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
        }
        pole.light(lighting, ContraptionRenderDispatcher.getLightOnContraption(context)).renderInto(ms, builder);
        hand.light(lighting, ContraptionRenderDispatcher.getLightOnContraption(context)).renderInto(ms, builder);
    }

    static AllBlockPartials getHandPose(DeployerTileEntity.Mode mode) {
        return mode == DeployerTileEntity.Mode.PUNCH ? AllBlockPartials.DEPLOYER_HAND_PUNCHING : AllBlockPartials.DEPLOYER_HAND_POINTING;
    }
}

