/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.flywheel;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.components.flywheel.engine.EngineTileEntity;
import com.simibubi.create.content.contraptions.components.flywheel.engine.FurnaceEngineBlock;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class FlywheelBlock
extends HorizontalKineticBlock {
    public static EnumProperty<ConnectionState> CONNECTION = EnumProperty.func_177709_a((String)"connection", ConnectionState.class);

    public FlywheelBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(CONNECTION, (Comparable)((Object)ConnectionState.NONE)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a((StateContainer.Builder<Block, BlockState>)builder.func_206894_a(new IProperty[]{CONNECTION}));
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.FLYWHEEL.create();
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction preferred = this.getPreferredHorizontalFacing(context);
        if (preferred != null) {
            return (BlockState)this.func_176223_P().func_206870_a(HORIZONTAL_FACING, (Comparable)preferred.func_176734_d());
        }
        return (BlockState)this.func_176223_P().func_206870_a(HORIZONTAL_FACING, (Comparable)context.func_195992_f());
    }

    public static boolean isConnected(BlockState state) {
        return FlywheelBlock.getConnection(state) != null;
    }

    public static Direction getConnection(BlockState state) {
        Direction facing = (Direction)state.func_177229_b(HORIZONTAL_FACING);
        ConnectionState connection = (ConnectionState)((Object)state.func_177229_b(CONNECTION));
        if (connection == ConnectionState.LEFT) {
            return facing.func_176735_f();
        }
        if (connection == ConnectionState.RIGHT) {
            return facing.func_176746_e();
        }
        return null;
    }

    public static void setConnection(World world, BlockPos pos, BlockState state, Direction direction) {
        Direction facing = (Direction)state.func_177229_b(HORIZONTAL_FACING);
        ConnectionState connection = ConnectionState.NONE;
        if (direction == facing.func_176746_e()) {
            connection = ConnectionState.RIGHT;
        }
        if (direction == facing.func_176735_f()) {
            connection = ConnectionState.LEFT;
        }
        world.func_180501_a(pos, (BlockState)state.func_206870_a(CONNECTION, (Comparable)((Object)connection)), 18);
        AllTriggers.triggerForNearbyPlayers(AllTriggers.FLYWHEEL, world, pos, 4);
    }

    @Override
    public boolean hasShaftTowards(IWorldReader world, BlockPos pos, BlockState state, Direction face) {
        return face == ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176734_d();
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176740_k();
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        BlockPos enginePos;
        Direction connection = FlywheelBlock.getConnection(state);
        if (connection == null) {
            return super.onWrenched(state, context);
        }
        if (context.func_196000_l().func_176740_k() == ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176740_k()) {
            return ActionResultType.PASS;
        }
        World world = context.func_195991_k();
        BlockState engine = world.func_180495_p(enginePos = context.func_195995_a().func_177967_a(connection, 2));
        if (engine.func_177230_c() instanceof FurnaceEngineBlock) {
            ((FurnaceEngineBlock)engine.func_177230_c()).withTileEntityDo((IBlockReader)world, enginePos, EngineTileEntity::detachWheel);
        }
        return super.onWrenched((BlockState)state.func_206870_a(CONNECTION, (Comparable)((Object)ConnectionState.NONE)), context);
    }

    public static enum ConnectionState implements IStringSerializable
    {
        NONE,
        LEFT,
        RIGHT;


        public String func_176610_l() {
            return Lang.asId(this.name());
        }
    }
}

