/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.mixer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.mixer.MechanicalMixerTileEntity;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.backend.FastRenderDispatcher;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorld;

public class MechanicalMixerRenderer
extends KineticTileEntityRenderer {
    public MechanicalMixerRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public boolean isGlobalRenderer(KineticTileEntity te) {
        return true;
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (FastRenderDispatcher.available(te.func_145831_w())) {
            return;
        }
        BlockState blockState = te.func_195044_w();
        MechanicalMixerTileEntity mixer = (MechanicalMixerTileEntity)te;
        BlockPos pos = te.func_174877_v();
        IVertexBuilder vb = buffer.getBuffer(RenderType.func_228639_c_());
        SuperByteBuffer superBuffer = AllBlockPartials.SHAFTLESS_COGWHEEL.renderOn(blockState);
        MechanicalMixerRenderer.standardKineticRotationTransform(superBuffer, te, light).renderInto(ms, vb);
        int packedLightmapCoords = WorldRenderer.func_228420_a_((ILightReader)te.func_145831_w(), (BlockState)blockState, (BlockPos)pos);
        float renderedHeadOffset = mixer.getRenderedHeadOffset(partialTicks);
        float speed = mixer.getRenderedHeadRotationSpeed(partialTicks);
        float time = AnimationTickHolder.getRenderTime((IWorld)te.func_145831_w());
        float angle = time * speed * 6.0f / 10.0f % 360.0f / 180.0f * (float)Math.PI;
        SuperByteBuffer poleRender = AllBlockPartials.MECHANICAL_MIXER_POLE.renderOn(blockState);
        poleRender.translate(0.0f, -renderedHeadOffset, 0.0f).light(packedLightmapCoords).renderInto(ms, vb);
        SuperByteBuffer headRender = AllBlockPartials.MECHANICAL_MIXER_HEAD.renderOn(blockState);
        headRender.rotateCentered(Direction.UP, angle).translate(0.0f, -renderedHeadOffset, 0.0f).light(packedLightmapCoords).renderInto(ms, vb);
    }
}

