/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.mixer;

import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.RotatingData;
import com.simibubi.create.content.contraptions.base.ShaftlessCogInstance;
import com.simibubi.create.content.contraptions.components.mixer.MechanicalMixerTileEntity;
import com.simibubi.create.foundation.render.backend.core.OrientedData;
import com.simibubi.create.foundation.render.backend.instancing.IDynamicInstance;
import com.simibubi.create.foundation.render.backend.instancing.InstancedTileRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.util.Direction;

public class MixerInstance
extends ShaftlessCogInstance
implements IDynamicInstance {
    private final RotatingData mixerHead;
    private final OrientedData mixerPole;
    private final MechanicalMixerTileEntity mixer;

    public MixerInstance(InstancedTileRenderer<?> dispatcher, MechanicalMixerTileEntity tile) {
        super(dispatcher, tile);
        this.mixer = tile;
        this.mixerHead = this.getRotatingMaterial().getModel(AllBlockPartials.MECHANICAL_MIXER_HEAD, this.blockState).createInstance();
        this.mixerHead.setRotationAxis(Direction.Axis.Y);
        this.mixerPole = this.getOrientedMaterial().getModel(AllBlockPartials.MECHANICAL_MIXER_POLE, this.blockState).createInstance();
        float renderedHeadOffset = this.getRenderedHeadOffset();
        this.transformPole(renderedHeadOffset);
        this.transformHead(renderedHeadOffset);
    }

    @Override
    public void beginFrame() {
        float renderedHeadOffset = this.getRenderedHeadOffset();
        this.transformPole(renderedHeadOffset);
        this.transformHead(renderedHeadOffset);
    }

    private void transformHead(float renderedHeadOffset) {
        float speed = this.mixer.getRenderedHeadRotationSpeed(AnimationTickHolder.getPartialTicks());
        this.mixerHead.setPosition(this.getInstancePosition()).nudge(0.0f, -renderedHeadOffset, 0.0f).setRotationalSpeed(speed * 2.0f);
    }

    private void transformPole(float renderedHeadOffset) {
        this.mixerPole.setPosition(this.getInstancePosition()).nudge(0.0f, -renderedHeadOffset, 0.0f);
    }

    private float getRenderedHeadOffset() {
        return this.mixer.getRenderedHeadOffset(AnimationTickHolder.getPartialTicks());
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos.func_177977_b(), this.mixerHead);
        this.relight(this.pos, this.mixerPole);
    }

    @Override
    public void remove() {
        super.remove();
        this.mixerHead.delete();
        this.mixerPole.delete();
    }
}

