/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.press;

import com.simibubi.create.content.contraptions.components.press.MechanicalPressTileEntity;
import com.simibubi.create.content.contraptions.components.press.PressingRecipe;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.InWorldProcessing;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.BeltProcessingBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;

public class BeltPressingCallbacks {
    static BeltProcessingBehaviour.ProcessingResult onItemReceived(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler, MechanicalPressTileEntity press) {
        if (press.getSpeed() == 0.0f || press.running) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (!press.getRecipe(transported.stack).isPresent()) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        press.start(MechanicalPressTileEntity.Mode.BELT);
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    static BeltProcessingBehaviour.ProcessingResult whenItemHeld(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler, MechanicalPressTileEntity pressTe) {
        if (pressTe.getSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (!pressTe.running) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (pressTe.runningTicks != 120) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        Optional<PressingRecipe> recipe = pressTe.getRecipe(transported.stack);
        pressTe.pressedItems.clear();
        pressTe.pressedItems.add(transported.stack);
        if (!recipe.isPresent()) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        List<TransportedItemStack> collect = InWorldProcessing.applyRecipeOn(transported.stack, (IRecipe)recipe.get()).stream().map(stack -> {
            TransportedItemStack copy = transported.copy();
            copy.stack = stack;
            return copy;
        }).collect(Collectors.toList());
        if (collect.isEmpty()) {
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.removeItem());
        } else {
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(collect));
        }
        pressTe.sendData();
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }
}

