/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.saw;

import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.components.actors.DrillBlock;
import com.simibubi.create.content.contraptions.components.saw.SawTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SawBlock
extends DirectionalAxisKineticBlock
implements ITE<SawTileEntity> {
    public static DamageSource damageSourceSaw = new DamageSource("create.mechanical_saw").func_76348_h();

    public SawBlock(Block.Properties properties) {
        super(properties);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState stateForPlacement = super.func_196258_a(context);
        Direction facing = (Direction)stateForPlacement.func_177229_b((IProperty)FACING);
        if (facing.func_176740_k().func_200128_b()) {
            return stateForPlacement;
        }
        return (BlockState)stateForPlacement.func_206870_a((IProperty)AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(facing.func_176740_k() == Direction.Axis.X));
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.SAW.create();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AllShapes.CASING_12PX.get((Direction)state.func_177229_b((IProperty)FACING));
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof ItemEntity) {
            return;
        }
        if (!new AxisAlignedBB(pos).func_186664_h((double)0.1f).func_72326_a(entityIn.func_174813_aQ())) {
            return;
        }
        this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
            if (te.getSpeed() == 0.0f) {
                return;
            }
            entityIn.func_70097_a(damageSourceSaw, (float)DrillBlock.getDamage(te.getSpeed()));
        });
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        super.func_176216_a(worldIn, entityIn);
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (entityIn.field_70170_p.field_72995_K) {
            return;
        }
        BlockPos pos = entityIn.func_180425_c();
        this.withTileEntityDo((IBlockReader)entityIn.field_70170_p, pos, te -> {
            if (te.getSpeed() == 0.0f) {
                return;
            }
            te.insertItem((ItemEntity)entityIn);
        });
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.NORMAL;
    }

    public static boolean isHorizontal(BlockState state) {
        return ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k().func_176722_c();
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return SawBlock.isHorizontal(state) ? ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k() : super.getRotationAxis(state);
    }

    @Override
    public boolean hasShaftTowards(IWorldReader world, BlockPos pos, BlockState state, Direction face) {
        return SawBlock.isHorizontal(state) ? face == ((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d() : super.hasShaftTowards(world, pos, state, face);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.hasTileEntity() || state.func_177230_c() == newState.func_177230_c()) {
            return;
        }
        this.withTileEntityDo((IBlockReader)worldIn, pos, te -> ItemHelper.dropContents(worldIn, pos, (IItemHandler)te.inventory));
        TileEntityBehaviour.destroy((IBlockReader)worldIn, pos, FilteringBehaviour.TYPE);
        worldIn.func_175713_t(pos);
    }

    @Override
    public Class<SawTileEntity> getTileEntityClass() {
        return SawTileEntity.class;
    }
}

