/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.render.RenderedContraption;
import com.simibubi.create.foundation.render.backend.light.GridAlignedBB;
import com.simibubi.create.foundation.render.backend.light.LightUpdateListener;
import com.simibubi.create.foundation.render.backend.light.LightUpdater;
import com.simibubi.create.foundation.render.backend.light.LightVolume;
import net.minecraft.world.ILightReader;
import net.minecraft.world.LightType;

public abstract class ContraptionLighter<C extends Contraption>
implements LightUpdateListener {
    protected final C contraption;
    public final LightVolume lightVolume;
    protected GridAlignedBB bounds;
    protected boolean scheduleRebuild;

    protected ContraptionLighter(C contraption) {
        this.contraption = contraption;
        this.bounds = this.getContraptionBounds();
        this.lightVolume = new LightVolume(this.contraptionBoundsToVolume(this.bounds.copy()));
        this.lightVolume.initialize((ILightReader)((Contraption)contraption).entity.field_70170_p);
        this.scheduleRebuild = true;
        this.startListening();
    }

    public void tick(RenderedContraption owner) {
        if (this.scheduleRebuild) {
            this.lightVolume.initialize((ILightReader)owner.contraption.entity.field_70170_p);
            this.scheduleRebuild = false;
        }
    }

    public abstract GridAlignedBB getContraptionBounds();

    @Override
    public boolean onLightUpdate(ILightReader world, LightType type, GridAlignedBB changed) {
        this.lightVolume.notifyLightUpdate(world, type, changed);
        return false;
    }

    @Override
    public boolean onLightPacket(ILightReader world, int chunkX, int chunkZ) {
        this.lightVolume.notifyLightPacket(world, chunkX, chunkZ);
        return false;
    }

    protected void startListening() {
        LightUpdater.getInstance().startListening(this.bounds, (LightUpdateListener)this);
    }

    protected GridAlignedBB contraptionBoundsToVolume(GridAlignedBB bounds) {
        bounds.grow(2);
        bounds.minY = Math.max(bounds.minY, 0);
        bounds.maxY = Math.min(bounds.maxY, 255);
        return bounds;
    }
}

