/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionCollider;
import com.simibubi.create.content.contraptions.components.structureMovement.IControlContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.contraptions.components.structureMovement.TranslatingContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.BearingContraption;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ControlledContraptionEntity
extends AbstractContraptionEntity {
    protected BlockPos controllerPos;
    protected Direction.Axis rotationAxis;
    protected float prevAngle;
    protected float angle;

    public ControlledContraptionEntity(EntityType<?> type, World world) {
        super(type, world);
    }

    public static ControlledContraptionEntity create(World world, IControlContraption controller, Contraption contraption) {
        ControlledContraptionEntity entity = new ControlledContraptionEntity(AllEntityTypes.CONTROLLED_CONTRAPTION.get(), world);
        entity.controllerPos = controller.getBlockPosition();
        entity.setContraption(contraption);
        return entity;
    }

    @Override
    public Vec3d getContactPointMotion(Vec3d globalContactPoint) {
        if (this.contraption instanceof TranslatingContraption) {
            return this.func_213322_ci();
        }
        return super.getContactPointMotion(globalContactPoint);
    }

    @Override
    protected void setContraption(Contraption contraption) {
        super.setContraption(contraption);
        if (contraption instanceof BearingContraption) {
            this.rotationAxis = ((BearingContraption)contraption).getFacing().func_176740_k();
        }
    }

    @Override
    protected void readAdditional(CompoundNBT compound, boolean spawnPacket) {
        super.readAdditional(compound, spawnPacket);
        this.controllerPos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("Controller"));
        if (compound.func_74764_b("Axis")) {
            this.rotationAxis = NBTHelper.readEnum(compound, "Axis", Direction.Axis.class);
        }
        this.angle = compound.func_74760_g("Angle");
    }

    @Override
    protected void writeAdditional(CompoundNBT compound, boolean spawnPacket) {
        super.writeAdditional(compound, spawnPacket);
        compound.func_218657_a("Controller", (INBT)NBTUtil.func_186859_a((BlockPos)this.controllerPos));
        if (this.rotationAxis != null) {
            NBTHelper.writeEnum(compound, "Axis", this.rotationAxis);
        }
        compound.func_74776_a("Angle", this.angle);
    }

    @Override
    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        AbstractContraptionEntity.ContraptionRotationState crs = new AbstractContraptionEntity.ContraptionRotationState();
        if (this.rotationAxis == Direction.Axis.X) {
            crs.xRotation = this.angle;
        }
        if (this.rotationAxis == Direction.Axis.Y) {
            crs.yRotation = this.angle;
        }
        if (this.rotationAxis == Direction.Axis.Z) {
            crs.zRotation = this.angle;
        }
        return crs;
    }

    @Override
    public Vec3d applyRotation(Vec3d localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, this.getAngle(partialTicks), this.rotationAxis);
        return localPos;
    }

    @Override
    public Vec3d reverseRotation(Vec3d localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, -this.getAngle(partialTicks), this.rotationAxis);
        return localPos;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public float getAngle(float partialTicks) {
        return partialTicks == 1.0f ? this.angle : AngleHelper.angleLerp(partialTicks, this.prevAngle, this.angle);
    }

    public void setRotationAxis(Direction.Axis rotationAxis) {
        this.rotationAxis = rotationAxis;
    }

    public Direction.Axis getRotationAxis() {
        return this.rotationAxis;
    }

    public void func_70634_a(double p_70634_1_, double p_70634_3_, double p_70634_5_) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yw, float pt, int inc, boolean t) {
    }

    @Override
    protected void tickContraption() {
        this.prevAngle = this.angle;
        this.tickActors();
        if (this.controllerPos == null) {
            return;
        }
        if (!this.field_70170_p.func_195588_v(this.controllerPos)) {
            return;
        }
        IControlContraption controller = this.getController();
        if (controller == null) {
            this.func_70106_y();
            return;
        }
        if (!controller.isAttachedTo(this)) {
            controller.attach(this);
            if (this.field_70170_p.field_72995_K) {
                this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            }
        }
        Vec3d motion = this.func_213322_ci();
        this.move(motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
        if (ContraptionCollider.collideBlocks(this)) {
            this.getController().collided();
        }
    }

    @Override
    protected boolean shouldActorTrigger(MovementContext context, Template.BlockInfo blockInfo, MovementBehaviour actor, Vec3d actorPosition, BlockPos gridPosition) {
        if (super.shouldActorTrigger(context, blockInfo, actor, actorPosition, gridPosition)) {
            return true;
        }
        if (!(this.contraption instanceof BearingContraption)) {
            return false;
        }
        BearingContraption bc = (BearingContraption)this.contraption;
        Direction facing = bc.getFacing();
        Vec3d activeAreaOffset = actor.getActiveAreaOffset(context);
        if (!activeAreaOffset.func_216369_h(VecHelper.axisAlingedPlaneOf(new Vec3d(facing.func_176730_m()))).equals((Object)Vec3d.field_186680_a)) {
            return false;
        }
        if (!VecHelper.onSameAxis(blockInfo.field_186242_a, BlockPos.field_177992_a, facing.func_176740_k())) {
            return false;
        }
        context.relativeMotion = context.motion = new Vec3d(facing.func_176730_m()).func_186678_a((double)(this.angle - this.prevAngle));
        int timer = context.data.func_74762_e("StationaryTimer");
        if (timer > 0) {
            context.data.func_74768_a("StationaryTimer", timer - 1);
            return false;
        }
        context.data.func_74768_a("StationaryTimer", 20);
        return true;
    }

    protected IControlContraption getController() {
        if (this.controllerPos == null) {
            return null;
        }
        if (!this.field_70170_p.func_195588_v(this.controllerPos)) {
            return null;
        }
        TileEntity te = this.field_70170_p.func_175625_s(this.controllerPos);
        if (!(te instanceof IControlContraption)) {
            return null;
        }
        return (IControlContraption)te;
    }

    @Override
    protected StructureTransform makeStructureTransform() {
        BlockPos offset = new BlockPos(this.getAnchorVec().func_72441_c(0.5, 0.5, 0.5));
        float xRot = this.rotationAxis == Direction.Axis.X ? this.angle : 0.0f;
        float yRot = this.rotationAxis == Direction.Axis.Y ? this.angle : 0.0f;
        float zRot = this.rotationAxis == Direction.Axis.Z ? this.angle : 0.0f;
        return new StructureTransform(offset, xRot, yRot, zRot);
    }

    @Override
    protected void onContraptionStalled() {
        IControlContraption controller = this.getController();
        if (controller != null) {
            controller.onStall();
        }
        super.onContraptionStalled();
    }

    @Override
    protected float getStalledAngle() {
        return this.angle;
    }

    @Override
    protected void handleStallInformation(float x, float y, float z, float angle) {
        this.func_226288_n_(x, y, z);
        this.angle = angle;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doLocalTransforms(float partialTicks, MatrixStack[] matrixStacks) {
        float angle = this.getAngle(partialTicks);
        Direction.Axis axis = this.getRotationAxis();
        for (MatrixStack stack : matrixStacks) {
            MatrixStacker.of(stack).nudge(this.func_145782_y()).centre().rotate(angle, axis).unCentre();
        }
    }
}

