/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.logistics.block.inventories.AdjustableCrateBlock;
import com.simibubi.create.content.logistics.block.inventories.BottomlessItemHandler;
import com.simibubi.create.foundation.utility.NBTHelper;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.BarrelTileEntity;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class MountedStorage {
    private static final ItemStackHandler dummyHandler = new ItemStackHandler();
    ItemStackHandler handler;
    boolean valid;
    private TileEntity te;

    public static boolean canUseAsStorage(TileEntity te) {
        if (te == null) {
            return false;
        }
        if (AllTileEntities.ADJUSTABLE_CRATE.is(te)) {
            return true;
        }
        if (AllTileEntities.CREATIVE_CRATE.is(te)) {
            return true;
        }
        if (te instanceof ShulkerBoxTileEntity) {
            return true;
        }
        if (te instanceof ChestTileEntity) {
            return true;
        }
        if (te instanceof BarrelTileEntity) {
            return true;
        }
        LazyOptional capability = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        return capability.orElse(null) instanceof ItemStackHandler;
    }

    public MountedStorage(TileEntity te) {
        this.te = te;
        this.handler = dummyHandler;
    }

    public void removeStorageFromWorld() {
        IItemHandler teHandler;
        this.valid = false;
        if (this.te == null) {
            return;
        }
        if (this.te.func_200662_C() == TileEntityType.field_200972_c || this.te.func_200662_C() == TileEntityType.field_200973_d) {
            if (this.te.func_195044_w().func_177229_b((IProperty)ChestBlock.field_196314_b) != ChestType.SINGLE) {
                this.te.func_145831_w().func_175656_a(this.te.func_174877_v(), (BlockState)this.te.func_195044_w().func_206870_a((IProperty)ChestBlock.field_196314_b, (Comparable)ChestType.SINGLE));
            }
            this.te.func_145836_u();
        }
        if (AllTileEntities.ADJUSTABLE_CRATE.is(this.te)) {
            if (((Boolean)this.te.func_195044_w().func_177229_b((IProperty)AdjustableCrateBlock.DOUBLE)).booleanValue()) {
                this.te.func_145831_w().func_175656_a(this.te.func_174877_v(), (BlockState)this.te.func_195044_w().func_206870_a((IProperty)AdjustableCrateBlock.DOUBLE, (Comparable)Boolean.valueOf(false)));
            }
            this.te.func_145836_u();
        }
        if ((teHandler = (IItemHandler)this.te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse((Object)dummyHandler)) == dummyHandler) {
            return;
        }
        if (teHandler instanceof ItemStackHandler) {
            this.handler = (ItemStackHandler)teHandler;
            this.valid = true;
            return;
        }
        if (teHandler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable inv = (IItemHandlerModifiable)teHandler;
            this.handler = new ItemStackHandler(teHandler.getSlots());
            for (int slot = 0; slot < this.handler.getSlots(); ++slot) {
                this.handler.setStackInSlot(slot, inv.getStackInSlot(slot));
                inv.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            this.valid = true;
            return;
        }
    }

    public void addStorageToWorld(TileEntity te) {
        if (this.handler instanceof BottomlessItemHandler) {
            return;
        }
        LazyOptional capability = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        IItemHandler teHandler = (IItemHandler)capability.orElse(null);
        if (!(teHandler instanceof IItemHandlerModifiable)) {
            return;
        }
        IItemHandlerModifiable inv = (IItemHandlerModifiable)teHandler;
        for (int slot = 0; slot < Math.min(inv.getSlots(), this.handler.getSlots()); ++slot) {
            inv.setStackInSlot(slot, this.handler.getStackInSlot(slot));
        }
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.handler;
    }

    public CompoundNBT serialize() {
        if (!this.valid) {
            return null;
        }
        CompoundNBT tag = this.handler.serializeNBT();
        if (this.handler instanceof BottomlessItemHandler) {
            NBTHelper.putMarker(tag, "Bottomless");
            tag.func_218657_a("ProvidedStack", (INBT)this.handler.getStackInSlot(0).serializeNBT());
        }
        return tag;
    }

    public static MountedStorage deserialize(CompoundNBT nbt) {
        MountedStorage storage = new MountedStorage(null);
        storage.handler = new ItemStackHandler();
        if (nbt == null) {
            return storage;
        }
        storage.valid = true;
        if (nbt.func_74764_b("Bottomless")) {
            ItemStack providedStack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("ProvidedStack"));
            storage.handler = new BottomlessItemHandler(() -> providedStack);
            return storage;
        }
        storage.handler.deserializeNBT(nbt);
        return storage;
    }

    public boolean isValid() {
        return this.valid;
    }
}

