/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.AbstractChassisBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.foundation.utility.DirectionHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.BellBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BellAttachment;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class StructureTransform {
    Rotation rotation;
    int angle;
    Direction.Axis rotationAxis;
    BlockPos offset;

    private StructureTransform(BlockPos offset, int angle, Direction.Axis axis, Rotation rotation) {
        this.offset = offset;
        this.angle = angle;
        this.rotationAxis = axis;
        this.rotation = rotation;
    }

    public StructureTransform(BlockPos offset, float xRotation, float yRotation, float zRotation) {
        this.offset = offset;
        if (xRotation != 0.0f) {
            this.rotationAxis = Direction.Axis.X;
            this.angle = Math.round(xRotation / 90.0f) * 90;
        }
        if (yRotation != 0.0f) {
            this.rotationAxis = Direction.Axis.Y;
            this.angle = Math.round(yRotation / 90.0f) * 90;
        }
        if (zRotation != 0.0f) {
            this.rotationAxis = Direction.Axis.Z;
            this.angle = Math.round(zRotation / 90.0f) * 90;
        }
        this.angle %= 360;
        if (this.angle < -90) {
            this.angle += 360;
        }
        this.rotation = Rotation.NONE;
        if (this.angle == -90 || this.angle == 270) {
            this.rotation = Rotation.CLOCKWISE_90;
        }
        if (this.angle == 90) {
            this.rotation = Rotation.COUNTERCLOCKWISE_90;
        }
        if (this.angle == 180) {
            this.rotation = Rotation.CLOCKWISE_180;
        }
    }

    public Vec3d apply(Vec3d localVec) {
        Vec3d vec = localVec;
        if (this.rotationAxis != null) {
            vec = VecHelper.rotateCentered(vec, this.angle, this.rotationAxis);
        }
        vec = vec.func_178787_e(new Vec3d((Vec3i)this.offset));
        return vec;
    }

    public BlockPos apply(BlockPos localPos) {
        Vec3d vec = VecHelper.getCenterOf((Vec3i)localPos);
        if (this.rotationAxis != null) {
            vec = VecHelper.rotateCentered(vec, this.angle, this.rotationAxis);
        }
        localPos = new BlockPos(vec);
        return localPos.func_177971_a((Vec3i)this.offset);
    }

    public BlockState apply(BlockState state) {
        boolean halfTurn;
        Block block = state.func_177230_c();
        if (this.rotationAxis == Direction.Axis.Y) {
            if (block instanceof BellBlock) {
                if (state.func_177229_b((IProperty)BlockStateProperties.field_222511_P) == BellAttachment.DOUBLE_WALL) {
                    state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_222511_P, (Comparable)BellAttachment.SINGLE_WALL);
                }
                return (BlockState)state.func_206870_a((IProperty)HorizontalFaceBlock.field_185512_D, (Comparable)this.rotation.func_185831_a((Direction)state.func_177229_b((IProperty)HorizontalFaceBlock.field_185512_D)));
            }
            return state.func_185907_a(this.rotation);
        }
        if (block instanceof AbstractChassisBlock) {
            return this.rotateChassis(state);
        }
        if (block instanceof HorizontalFaceBlock) {
            Direction forcedAxis;
            Direction stateFacing = (Direction)state.func_177229_b((IProperty)HorizontalFaceBlock.field_185512_D);
            AttachFace stateFace = (AttachFace)state.func_177229_b((IProperty)HorizontalFaceBlock.field_196366_M);
            Direction direction = forcedAxis = this.rotationAxis == Direction.Axis.Z ? Direction.EAST : Direction.SOUTH;
            if (stateFacing.func_176740_k() == this.rotationAxis && stateFace == AttachFace.WALL) {
                return state;
            }
            for (int i = 0; i < this.rotation.ordinal(); ++i) {
                stateFace = (AttachFace)state.func_177229_b((IProperty)HorizontalFaceBlock.field_196366_M);
                stateFacing = (Direction)state.func_177229_b((IProperty)HorizontalFaceBlock.field_185512_D);
                boolean b = state.func_177229_b((IProperty)HorizontalFaceBlock.field_196366_M) == AttachFace.CEILING;
                state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)(b ? forcedAxis : forcedAxis.func_176734_d()));
                state = stateFace != AttachFace.WALL ? (BlockState)state.func_206870_a((IProperty)HorizontalFaceBlock.field_196366_M, (Comparable)AttachFace.WALL) : (stateFacing.func_176743_c() == Direction.AxisDirection.POSITIVE ? (BlockState)state.func_206870_a((IProperty)HorizontalFaceBlock.field_196366_M, (Comparable)AttachFace.FLOOR) : (BlockState)state.func_206870_a((IProperty)HorizontalFaceBlock.field_196366_M, (Comparable)AttachFace.CEILING));
            }
            return state;
        }
        boolean bl = halfTurn = this.rotation == Rotation.CLOCKWISE_180;
        if (block instanceof StairsBlock) {
            state = this.transformStairs(state, halfTurn);
            return state;
        }
        if (AllBlocks.BELT.has(state)) {
            state = this.transformBelt(state, halfTurn);
            return state;
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208155_H)) {
            Direction newFacing = this.transformFacing((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H));
            if (state.func_196959_b((IProperty)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) && this.rotationAxis == newFacing.func_176740_k() && this.rotation.ordinal() % 2 == 1) {
                state = (BlockState)state.func_177231_a((IProperty)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
            }
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)newFacing);
        } else if (state.func_196959_b((IProperty)BlockStateProperties.field_208148_A)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208148_A, (Comparable)this.transformAxis((Direction.Axis)state.func_177229_b((IProperty)BlockStateProperties.field_208148_A)));
        } else if (halfTurn) {
            Direction stateFacing;
            if (state.func_196959_b((IProperty)BlockStateProperties.field_208155_H) && (stateFacing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H)).func_176740_k() == this.rotationAxis) {
                return state;
            }
            if (state.func_196959_b((IProperty)BlockStateProperties.field_208157_J) && (stateFacing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)).func_176740_k() == this.rotationAxis) {
                return state;
            }
            if ((state = state.func_185907_a(this.rotation)).func_196959_b((IProperty)SlabBlock.field_196505_a) && state.func_177229_b((IProperty)SlabBlock.field_196505_a) != SlabType.DOUBLE) {
                state = (BlockState)state.func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)(state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM ? SlabType.TOP : SlabType.BOTTOM));
            }
        }
        return state;
    }

    protected BlockState transformStairs(BlockState state, boolean halfTurn) {
        if (((Direction)state.func_177229_b((IProperty)StairsBlock.field_176309_a)).func_176740_k() != this.rotationAxis) {
            for (int i = 0; i < this.rotation.ordinal(); ++i) {
                Direction direction = (Direction)state.func_177229_b((IProperty)StairsBlock.field_176309_a);
                Half half = (Half)state.func_177229_b((IProperty)StairsBlock.field_176308_b);
                state = direction.func_176743_c() == Direction.AxisDirection.POSITIVE ^ half == Half.BOTTOM ^ direction.func_176740_k() == Direction.Axis.Z ? (BlockState)state.func_177231_a((IProperty)StairsBlock.field_176308_b) : (BlockState)state.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)direction.func_176734_d());
            }
        } else if (halfTurn) {
            state = (BlockState)state.func_177231_a((IProperty)StairsBlock.field_176308_b);
        }
        return state;
    }

    protected BlockState transformBelt(BlockState state, boolean halfTurn) {
        boolean diagonal;
        Direction initialDirection = (Direction)state.func_177229_b(BeltBlock.HORIZONTAL_FACING);
        boolean bl = diagonal = state.func_177229_b(BeltBlock.SLOPE) == BeltSlope.DOWNWARD || state.func_177229_b(BeltBlock.SLOPE) == BeltSlope.UPWARD;
        if (!diagonal) {
            for (int i = 0; i < this.rotation.ordinal(); ++i) {
                Direction direction = (Direction)state.func_177229_b(BeltBlock.HORIZONTAL_FACING);
                BeltSlope slope = (BeltSlope)((Object)state.func_177229_b(BeltBlock.SLOPE));
                boolean vertical = slope == BeltSlope.VERTICAL;
                boolean horizontal = slope == BeltSlope.HORIZONTAL;
                boolean sideways = slope == BeltSlope.SIDEWAYS;
                Direction newDirection = direction.func_176734_d();
                BeltSlope newSlope = BeltSlope.VERTICAL;
                if (vertical) {
                    if (direction.func_176740_k() == this.rotationAxis) {
                        newDirection = direction.func_176735_f();
                        newSlope = BeltSlope.SIDEWAYS;
                    } else {
                        newSlope = BeltSlope.HORIZONTAL;
                        newDirection = direction;
                        if (direction.func_176740_k() == Direction.Axis.Z) {
                            newDirection = direction.func_176734_d();
                        }
                    }
                }
                if (sideways) {
                    newDirection = direction;
                    if (direction.func_176740_k() == this.rotationAxis) {
                        newSlope = BeltSlope.HORIZONTAL;
                    } else {
                        newDirection = direction.func_176735_f();
                    }
                }
                if (horizontal) {
                    newDirection = direction;
                    if (direction.func_176740_k() == this.rotationAxis) {
                        newSlope = BeltSlope.SIDEWAYS;
                    } else if (direction.func_176740_k() != Direction.Axis.Z) {
                        newDirection = direction.func_176734_d();
                    }
                }
                state = (BlockState)state.func_206870_a(BeltBlock.HORIZONTAL_FACING, (Comparable)newDirection);
                state = (BlockState)state.func_206870_a(BeltBlock.SLOPE, (Comparable)((Object)newSlope));
            }
        } else if (initialDirection.func_176740_k() != this.rotationAxis) {
            for (int i = 0; i < this.rotation.ordinal(); ++i) {
                Direction direction = (Direction)state.func_177229_b(BeltBlock.HORIZONTAL_FACING);
                Direction newDirection = direction.func_176734_d();
                BeltSlope slope = (BeltSlope)((Object)state.func_177229_b(BeltBlock.SLOPE));
                boolean upward = slope == BeltSlope.UPWARD;
                boolean downward = slope == BeltSlope.DOWNWARD;
                state = direction.func_176743_c() == Direction.AxisDirection.POSITIVE ^ downward ^ direction.func_176740_k() == Direction.Axis.Z ? (BlockState)state.func_206870_a(BeltBlock.SLOPE, (Comparable)((Object)(upward ? BeltSlope.DOWNWARD : BeltSlope.UPWARD))) : (BlockState)state.func_206870_a(BeltBlock.HORIZONTAL_FACING, (Comparable)newDirection);
            }
        } else if (halfTurn) {
            boolean vertical;
            Direction direction = (Direction)state.func_177229_b(BeltBlock.HORIZONTAL_FACING);
            Direction newDirection = direction.func_176734_d();
            BeltSlope slope = (BeltSlope)((Object)state.func_177229_b(BeltBlock.SLOPE));
            boolean bl2 = vertical = slope == BeltSlope.VERTICAL;
            if (diagonal) {
                state = (BlockState)state.func_206870_a(BeltBlock.SLOPE, (Comparable)((Object)(slope == BeltSlope.UPWARD ? BeltSlope.DOWNWARD : (slope == BeltSlope.DOWNWARD ? BeltSlope.UPWARD : slope))));
            } else if (vertical) {
                state = (BlockState)state.func_206870_a(BeltBlock.HORIZONTAL_FACING, (Comparable)newDirection);
            }
        }
        return state;
    }

    public Direction.Axis transformAxis(Direction.Axis axisIn) {
        Direction facing = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axisIn);
        facing = this.transformFacing(facing);
        Direction.Axis axis = facing.func_176740_k();
        return axis;
    }

    public Direction transformFacing(Direction facing) {
        for (int i = 0; i < this.rotation.ordinal(); ++i) {
            facing = DirectionHelper.rotateAround(facing, this.rotationAxis);
        }
        return facing;
    }

    private BlockState rotateChassis(BlockState state) {
        BooleanProperty glueableSide;
        if (this.rotation == Rotation.NONE) {
            return state;
        }
        BlockState rotated = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208148_A, (Comparable)this.transformAxis((Direction.Axis)state.func_177229_b((IProperty)BlockStateProperties.field_208148_A)));
        AbstractChassisBlock block = (AbstractChassisBlock)state.func_177230_c();
        for (Direction face : Iterate.directions) {
            glueableSide = block.getGlueableSide(rotated, face);
            if (glueableSide == null) continue;
            rotated = (BlockState)rotated.func_206870_a((IProperty)glueableSide, (Comparable)Boolean.valueOf(false));
        }
        for (Direction face : Iterate.directions) {
            Direction rotatedFacing;
            BooleanProperty rotatedGlueableSide;
            glueableSide = block.getGlueableSide(state, face);
            if (glueableSide == null || !((Boolean)state.func_177229_b((IProperty)glueableSide)).booleanValue() || (rotatedGlueableSide = block.getGlueableSide(rotated, rotatedFacing = this.transformFacing(face))) == null) continue;
            rotated = (BlockState)rotated.func_206870_a((IProperty)rotatedGlueableSide, (Comparable)Boolean.valueOf(true));
        }
        return rotated;
    }

    public static StructureTransform fromBuffer(PacketBuffer buffer) {
        BlockPos readBlockPos = buffer.func_179259_c();
        int readAngle = buffer.readInt();
        int axisIndex = buffer.func_150792_a();
        int rotationIndex = buffer.func_150792_a();
        return new StructureTransform(readBlockPos, readAngle, axisIndex == -1 ? null : Direction.Axis.values()[axisIndex], rotationIndex == -1 ? null : Rotation.values()[rotationIndex]);
    }

    public void writeToBuffer(PacketBuffer buffer) {
        buffer.func_179255_a(this.offset);
        buffer.writeInt(this.angle);
        buffer.func_150787_b(this.rotationAxis == null ? -1 : this.rotationAxis.ordinal());
        buffer.func_150787_b(this.rotation == null ? -1 : this.rotation.ordinal());
    }
}

