/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.BearingInstance;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.StabilizedBearingInstance;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ActorInstance;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionKineticRenderer;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.backend.FastRenderDispatcher;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StabilizedBearingMovementBehaviour
extends MovementBehaviour {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, MatrixStack ms, MatrixStack msLocal, IRenderTypeBuffer buffer) {
        if (FastRenderDispatcher.available()) {
            return;
        }
        Direction facing = (Direction)context.state.func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        AllBlockPartials top = AllBlockPartials.BEARING_TOP;
        SuperByteBuffer superBuffer = top.renderOn(context.state);
        float renderPartialTicks = AnimationTickHolder.getPartialTicks();
        Quaternion orientation = BearingInstance.getBlockStateOrientation(facing);
        float angle = StabilizedBearingMovementBehaviour.getCounterRotationAngle(context, facing, renderPartialTicks) * (float)facing.func_176743_c().func_179524_a();
        Quaternion rotation = facing.func_229386_k_().func_229187_a_(angle);
        rotation.func_195890_a(orientation);
        orientation = rotation;
        superBuffer.rotateCentered(orientation);
        superBuffer.light(msLocal.func_227866_c_().func_227870_a_(), ContraptionRenderDispatcher.getLightOnContraption(context));
        superBuffer.renderInto(ms, buffer.getBuffer(RenderType.func_228639_c_()));
    }

    @Override
    public boolean hasSpecialInstancedRendering() {
        return true;
    }

    @Override
    @Nullable
    public ActorInstance createInstance(ContraptionKineticRenderer kr, MovementContext context) {
        return new StabilizedBearingInstance(kr, context);
    }

    static float getCounterRotationAngle(MovementContext context, Direction facing, float renderPartialTicks) {
        float offset = 0.0f;
        Direction.Axis axis = facing.func_176740_k();
        AbstractContraptionEntity entity = context.contraption.entity;
        if (entity instanceof ControlledContraptionEntity) {
            ControlledContraptionEntity controlledCE = (ControlledContraptionEntity)entity;
            if (context.contraption.canBeStabilized(facing, context.localPos)) {
                offset = -controlledCE.getAngle(renderPartialTicks);
            }
        } else if (entity instanceof OrientedContraptionEntity) {
            OrientedContraptionEntity orientedCE = (OrientedContraptionEntity)entity;
            if (axis.func_200128_b()) {
                offset = -orientedCE.func_195046_g(renderPartialTicks);
            } else if (orientedCE.isInitialOrientationPresent() && orientedCE.getInitialOrientation().func_176740_k() == axis) {
                offset = -orientedCE.func_195050_f(renderPartialTicks);
            }
        }
        return offset;
    }
}

