/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.chassis;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.StickerBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.StickerTileEntity;
import com.simibubi.create.foundation.render.backend.core.ModelData;
import com.simibubi.create.foundation.render.backend.instancing.IDynamicInstance;
import com.simibubi.create.foundation.render.backend.instancing.InstancedTileRenderer;
import com.simibubi.create.foundation.render.backend.instancing.TileEntityInstance;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.MatrixStacker;
import net.minecraft.client.Minecraft;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;

public class StickerInstance
extends TileEntityInstance<StickerTileEntity>
implements IDynamicInstance {
    float lastOffset = Float.NaN;
    final Direction facing;
    final boolean fakeWorld;
    final int offset;
    private final ModelData head = this.getTransformMaterial().getModel(AllBlockPartials.STICKER_HEAD, this.blockState).createInstance();

    public StickerInstance(InstancedTileRenderer<?> modelManager, StickerTileEntity tile) {
        super(modelManager, tile);
        this.fakeWorld = tile.func_145831_w() != Minecraft.func_71410_x().field_71441_e;
        this.facing = (Direction)this.blockState.func_177229_b((IProperty)StickerBlock.field_176387_N);
        this.offset = (Boolean)this.blockState.func_177229_b((IProperty)StickerBlock.EXTENDED) != false ? 1 : 0;
        this.animateHead(this.offset);
    }

    @Override
    public void beginFrame() {
        float offset = ((StickerTileEntity)this.tile).piston.getValue(AnimationTickHolder.getPartialTicks());
        if (this.fakeWorld) {
            offset = this.offset;
        }
        if (MathHelper.func_180185_a((float)offset, (float)this.lastOffset)) {
            return;
        }
        this.animateHead(offset);
        this.lastOffset = offset;
    }

    private void animateHead(float offset) {
        MatrixStack stack = new MatrixStack();
        MatrixStacker.of(stack).translate((Vec3i)this.getInstancePosition()).nudge(((StickerTileEntity)this.tile).hashCode()).centre().rotateY(AngleHelper.horizontalAngle(this.facing)).rotateX(AngleHelper.verticalAngle(this.facing) + 90.0f).unCentre().translate(0.0, offset * offset * 4.0f / 16.0f, 0.0);
        this.head.setTransform(stack);
    }

    @Override
    public void updateLight() {
        this.relight(this.pos, this.head);
    }

    @Override
    public void remove() {
        this.head.delete();
    }
}

