/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.gantry;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryCarriageTileEntity;
import com.simibubi.create.content.contraptions.relays.advanced.GantryShaftBlock;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class GantryCarriageBlock
extends DirectionalAxisKineticBlock
implements ITE<GantryCarriageTileEntity> {
    public GantryCarriageBlock(Block.Properties properties) {
        super(properties);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        BlockState shaft = world.func_180495_p(pos.func_177972_a(direction.func_176734_d()));
        return AllBlocks.GANTRY_SHAFT.has(shaft) && ((Direction)shaft.func_177229_b((IProperty)GantryShaftBlock.FACING)).func_176740_k() != direction.func_176740_k();
    }

    @Override
    public void func_196242_c(BlockState stateIn, IWorld worldIn, BlockPos pos, int flags) {
        super.func_196242_c(stateIn, worldIn, pos, flags);
        this.withTileEntityDo((IBlockReader)worldIn, pos, GantryCarriageTileEntity::checkValidGantryShaft);
    }

    @Override
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.GANTRY_PINION.create();
    }

    @Override
    protected Direction getFacingForPlacement(BlockItemUseContext context) {
        return context.func_196000_l();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!player.func_175142_cm() || player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        if (player.func_184586_b(handIn).func_190926_b()) {
            this.withTileEntityDo((IBlockReader)worldIn, pos, te -> te.checkValidGantryShaft());
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState stateForPlacement = super.func_196258_a(context);
        Direction opposite = ((Direction)stateForPlacement.func_177229_b((IProperty)FACING)).func_176734_d();
        return this.cycleAxisIfNecessary(stateForPlacement, opposite, context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(opposite)));
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block p_220069_4_, BlockPos updatePos, boolean p_220069_6_) {
        if (updatePos.equals((Object)pos.func_177972_a(((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d())) && !this.func_196260_a(state, (IWorldReader)world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState otherState, IWorld world, BlockPos pos, BlockPos p_196271_6_) {
        if (state.func_177229_b((IProperty)FACING) != direction.func_176734_d()) {
            return state;
        }
        return this.cycleAxisIfNecessary(state, direction, otherState);
    }

    protected BlockState cycleAxisIfNecessary(BlockState state, Direction direction, BlockState otherState) {
        if (!AllBlocks.GANTRY_SHAFT.has(otherState)) {
            return state;
        }
        if (((Direction)otherState.func_177229_b((IProperty)GantryShaftBlock.FACING)).func_176740_k() == direction.func_176740_k()) {
            return state;
        }
        if (GantryCarriageBlock.isValidGantryShaftAxis(state, otherState)) {
            return state;
        }
        return (BlockState)state.func_177231_a((IProperty)AXIS_ALONG_FIRST_COORDINATE);
    }

    public static boolean isValidGantryShaftAxis(BlockState pinionState, BlockState gantryState) {
        return GantryCarriageBlock.getValidGantryShaftAxis(pinionState) == ((Direction)gantryState.func_177229_b((IProperty)GantryShaftBlock.FACING)).func_176740_k();
    }

    public static Direction.Axis getValidGantryShaftAxis(BlockState state) {
        if (!(state.func_177230_c() instanceof GantryCarriageBlock)) {
            return Direction.Axis.Y;
        }
        IRotate block = (IRotate)state.func_177230_c();
        Direction.Axis rotationAxis = block.getRotationAxis(state);
        Direction.Axis facingAxis = ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k();
        for (Direction.Axis axis : Iterate.axes) {
            if (axis == rotationAxis || axis == facingAxis) continue;
            return axis;
        }
        return Direction.Axis.Y;
    }

    public static Direction.Axis getValidGantryPinionAxis(BlockState state, Direction.Axis shaftAxis) {
        Direction.Axis facingAxis = ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k();
        for (Direction.Axis axis : Iterate.axes) {
            if (axis == shaftAxis || axis == facingAxis) continue;
            return axis;
        }
        return Direction.Axis.Y;
    }

    @Override
    public Class<GantryCarriageTileEntity> getTileEntityClass() {
        return GantryCarriageTileEntity.class;
    }
}

