/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.pulley;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class AbstractPulleyRenderer
extends KineticTileEntityRenderer {
    private AllBlockPartials halfRope;
    private AllBlockPartials halfMagnet;

    public AbstractPulleyRenderer(TileEntityRendererDispatcher dispatcher, AllBlockPartials halfRope, AllBlockPartials halfMagnet) {
        super(dispatcher);
        this.halfRope = halfRope;
        this.halfMagnet = halfMagnet;
    }

    public boolean isGlobalRenderer(KineticTileEntity p_188185_1_) {
        return true;
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        float offset = this.getOffset(te, partialTicks);
        boolean running = this.isRunning(te);
        Direction.Axis rotationAxis = ((IRotate)te.func_195044_w().func_177230_c()).getRotationAxis(te.func_195044_w());
        AbstractPulleyRenderer.kineticRotationTransform(this.getRotatedCoil(te), te, rotationAxis, AngleHelper.rad(offset * 180.0f), light).renderInto(ms, buffer.getBuffer(RenderType.func_228639_c_()));
        World world = te.func_145831_w();
        BlockState blockState = te.func_195044_w();
        BlockPos pos = te.func_174877_v();
        SuperByteBuffer halfMagnet = this.halfMagnet.renderOn(blockState);
        SuperByteBuffer halfRope = this.halfRope.renderOn(blockState);
        SuperByteBuffer magnet = this.renderMagnet(te);
        SuperByteBuffer rope = this.renderRope(te);
        IVertexBuilder vb = buffer.getBuffer(RenderType.func_228639_c_());
        if (running || offset == 0.0f) {
            this.renderAt((IWorld)world, offset > 0.25f ? magnet : halfMagnet, offset, pos, ms, vb);
        }
        float f = offset % 1.0f;
        if (offset > 0.75f && (f < 0.25f || f > 0.75f)) {
            this.renderAt((IWorld)world, halfRope, f > 0.75f ? f - 1.0f : f, pos, ms, vb);
        }
        if (!running) {
            return;
        }
        int i = 0;
        while ((float)i < offset - 1.25f) {
            this.renderAt((IWorld)world, rope, offset - (float)i - 1.0f, pos, ms, vb);
            ++i;
        }
    }

    private void renderAt(IWorld world, SuperByteBuffer partial, float offset, BlockPos pulleyPos, MatrixStack ms, IVertexBuilder buffer) {
        BlockPos actualPos = pulleyPos.func_177979_c((int)offset);
        int light = WorldRenderer.func_228420_a_((ILightReader)world, (BlockState)world.func_180495_p(actualPos), (BlockPos)actualPos);
        partial.translate(0.0f, -offset, 0.0f).light(light).renderInto(ms, buffer);
    }

    protected abstract Direction.Axis getShaftAxis(KineticTileEntity var1);

    protected abstract AllBlockPartials getCoil();

    protected abstract SuperByteBuffer renderRope(KineticTileEntity var1);

    protected abstract SuperByteBuffer renderMagnet(KineticTileEntity var1);

    protected abstract float getOffset(KineticTileEntity var1, float var2);

    protected abstract boolean isRunning(KineticTileEntity var1);

    @Override
    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        return AbstractPulleyRenderer.shaft(this.getShaftAxis(te));
    }

    protected SuperByteBuffer getRotatedCoil(KineticTileEntity te) {
        BlockState blockState = te.func_195044_w();
        return this.getCoil().renderOnDirectionalSouth(blockState, Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.getShaftAxis(te)));
    }
}

