/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionKineticRenderer;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionModel;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionProgram;
import com.simibubi.create.foundation.render.backend.Backend;
import com.simibubi.create.foundation.render.backend.instancing.IInstanceRendered;
import com.simibubi.create.foundation.render.backend.light.GridAlignedBB;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class RenderedContraption {
    private final HashMap<RenderType, ContraptionModel> renderLayers = new HashMap();
    public final PlacementSimulationWorld renderWorld;
    private final ContraptionLighter<?> lighter;
    public final ContraptionKineticRenderer kinetics;
    public Contraption contraption;
    private Matrix4f model;
    private AxisAlignedBB lightBox;

    public RenderedContraption(World world, Contraption contraption) {
        this.contraption = contraption;
        this.lighter = contraption.makeLighter();
        this.kinetics = new ContraptionKineticRenderer(this);
        this.renderWorld = RenderedContraption.setupRenderWorld(world, contraption);
        this.buildLayers();
        if (Backend.canUseInstancing()) {
            this.buildInstancedTiles();
            this.buildActors();
        }
    }

    public int getEntityId() {
        return this.contraption.entity.func_145782_y();
    }

    public boolean isDead() {
        return !this.contraption.entity.func_70089_S();
    }

    public ContraptionLighter<?> getLighter() {
        return this.lighter;
    }

    public void doRenderLayer(RenderType layer, ContraptionProgram shader) {
        ContraptionModel structure = this.renderLayers.get(layer);
        if (structure != null) {
            this.setup(shader);
            structure.render();
            this.teardown();
        }
    }

    public void beginFrame(ActiveRenderInfo info, double camX, double camY, double camZ) {
        this.kinetics.beginFrame(info, camX, camY, camZ);
        AbstractContraptionEntity entity = this.contraption.entity;
        float pt = AnimationTickHolder.getPartialTicks();
        MatrixStack stack = new MatrixStack();
        double x = MathHelper.func_219803_d((double)pt, (double)entity.field_70142_S, (double)entity.func_226277_ct_()) - camX;
        double y = MathHelper.func_219803_d((double)pt, (double)entity.field_70137_T, (double)entity.func_226278_cu_()) - camY;
        double z = MathHelper.func_219803_d((double)pt, (double)entity.field_70136_U, (double)entity.func_226281_cx_()) - camZ;
        stack.func_227861_a_(x, y, z);
        entity.doLocalTransforms(pt, new MatrixStack[]{stack});
        this.model = stack.func_227866_c_().func_227870_a_();
        AxisAlignedBB lightBox = GridAlignedBB.toAABB(this.lighter.lightVolume.getTextureVolume());
        this.lightBox = lightBox.func_72317_d(-camX, -camY, -camZ);
    }

    void setup(ContraptionProgram shader) {
        if (this.model == null || this.lightBox == null) {
            return;
        }
        shader.bind(this.model, this.lightBox);
        this.lighter.lightVolume.bind();
    }

    void teardown() {
        this.lighter.lightVolume.unbind();
    }

    void invalidate() {
        for (ContraptionModel buffer : this.renderLayers.values()) {
            buffer.delete();
        }
        this.renderLayers.clear();
        this.lighter.lightVolume.delete();
        this.kinetics.invalidate();
    }

    private void buildLayers() {
        for (ContraptionModel buffer : this.renderLayers.values()) {
            buffer.delete();
        }
        this.renderLayers.clear();
        List blockLayers = RenderType.func_228661_n_();
        for (RenderType layer : blockLayers) {
            this.renderLayers.put(layer, RenderedContraption.buildStructureModel(this.renderWorld, this.contraption, layer));
        }
    }

    private void buildInstancedTiles() {
        List<TileEntity> tileEntities = this.contraption.maybeInstancedTileEntities;
        if (!tileEntities.isEmpty()) {
            for (TileEntity te : tileEntities) {
                if (!(te instanceof IInstanceRendered)) continue;
                World world = te.func_145831_w();
                BlockPos pos = te.func_174877_v();
                te.func_226984_a_((World)this.renderWorld, pos);
                this.kinetics.add(te);
                te.func_226984_a_(world, pos);
            }
        }
    }

    private void buildActors() {
        this.contraption.getActors().forEach(this.kinetics::createActor);
    }

    private static ContraptionModel buildStructureModel(PlacementSimulationWorld renderWorld, Contraption c, RenderType layer) {
        BufferBuilder builder = RenderedContraption.buildStructure(renderWorld, c, layer);
        return new ContraptionModel(builder);
    }

    private static PlacementSimulationWorld setupRenderWorld(World world, Contraption c) {
        PlacementSimulationWorld renderWorld = new PlacementSimulationWorld(world);
        renderWorld.setTileEntities(c.presentTileEntities.values());
        for (Template.BlockInfo info : c.getBlocks().values()) {
            renderWorld.func_175656_a(info.field_186242_a, info.field_186243_b);
        }
        WorldLightManager lighter = renderWorld.lighter;
        renderWorld.field_73020_y.getLightSources().forEach(pos -> lighter.func_215573_a(pos, renderWorld.func_217298_h((BlockPos)pos)));
        lighter.func_215575_a(Integer.MAX_VALUE, true, false);
        return renderWorld;
    }

    private static BufferBuilder buildStructure(PlacementSimulationWorld renderWorld, Contraption c, RenderType layer) {
        ForgeHooksClient.setRenderLayer((RenderType)layer);
        MatrixStack ms = new MatrixStack();
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        BlockModelRenderer blockRenderer = dispatcher.func_175019_b();
        Random random = new Random();
        BufferBuilder builder = new BufferBuilder(DefaultVertexFormats.field_176600_a.func_181719_f());
        builder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (Template.BlockInfo info : c.getBlocks().values()) {
            BlockState state = info.field_186243_b;
            if (state.func_185901_i() == BlockRenderType.ENTITYBLOCK_ANIMATED || !RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)layer)) continue;
            IBakedModel originalModel = dispatcher.func_184389_a(state);
            ms.func_227860_a_();
            ms.func_227861_a_((double)info.field_186242_a.func_177958_n(), (double)info.field_186242_a.func_177956_o(), (double)info.field_186242_a.func_177952_p());
            blockRenderer.renderModel((ILightReader)renderWorld, originalModel, state, info.field_186242_a, ms, (IVertexBuilder)builder, true, random, 42L, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
            ms.func_227865_b_();
        }
        builder.func_178977_d();
        return builder;
    }
}

