/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.sync;

import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class ContraptionInteractionPacket
extends SimplePacketBase {
    private Hand interactionHand;
    private int target;
    private BlockPos localPos;
    private Direction face;

    public ContraptionInteractionPacket(AbstractContraptionEntity target, Hand hand, BlockPos localPos, Direction side) {
        this.interactionHand = hand;
        this.localPos = localPos;
        this.target = target.func_145782_y();
        this.face = side;
    }

    public ContraptionInteractionPacket(PacketBuffer buffer) {
        this.target = buffer.readInt();
        int handId = buffer.readInt();
        this.interactionHand = handId == -1 ? null : Hand.values()[handId];
        this.localPos = buffer.func_179259_c();
        this.face = Direction.func_82600_a((int)buffer.readShort());
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.target);
        buffer.writeInt(this.interactionHand == null ? -1 : this.interactionHand.ordinal());
        buffer.func_179255_a(this.localPos);
        buffer.writeShort(this.face.func_176745_a());
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)context.get()).getSender();
            if (sender == null) {
                return;
            }
            Entity entityByID = sender.func_71121_q().func_73045_a(this.target);
            if (!(entityByID instanceof AbstractContraptionEntity)) {
                return;
            }
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entityByID;
            double d = sender.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
            if (!sender.func_70685_l(entityByID)) {
                d -= 3.0;
            }
            d *= d;
            if (sender.func_70068_e(entityByID) > d) {
                return;
            }
            if (contraptionEntity.handlePlayerInteraction((PlayerEntity)sender, this.localPos, this.face, this.interactionHand)) {
                sender.func_226292_a_(this.interactionHand, true);
            }
        });
        context.get().setPacketHandled(true);
    }
}

