/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.fluids.FlowSource;
import com.simibubi.create.content.contraptions.fluids.FluidFX;
import com.simibubi.create.content.contraptions.fluids.FluidNetwork;
import com.simibubi.create.content.contraptions.fluids.FluidPropagator;
import com.simibubi.create.content.contraptions.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.contraptions.fluids.OpenEndedPipe;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.DistExecutor;

public class PipeConnection {
    Direction side;
    Couple<Float> pressure;
    Optional<FlowSource> source;
    Optional<FlowSource> previousSource;
    Optional<Flow> flow;
    boolean particleSplashNextTick;
    Optional<FluidNetwork> network;
    public static final int MAX_PARTICLE_RENDER_DISTANCE = 20;
    public static final int SPLASH_PARTICLE_AMOUNT = 1;
    public static final float IDLE_PARTICLE_SPAWN_CHANCE = 0.001f;
    public static final float RIM_RADIUS = 0.265625f;
    public static final Random r = new Random();

    public PipeConnection(Direction side) {
        this.side = side;
        this.pressure = Couple.create(() -> Float.valueOf(0.0f));
        this.flow = Optional.empty();
        this.previousSource = Optional.empty();
        this.source = Optional.empty();
        this.network = Optional.empty();
        this.particleSplashNextTick = false;
    }

    public FluidStack getProvidedFluid() {
        FluidStack empty = FluidStack.EMPTY;
        if (!this.hasFlow()) {
            return empty;
        }
        Flow flow = this.flow.get();
        if (!flow.inbound) {
            return empty;
        }
        if (!flow.complete) {
            return empty;
        }
        return flow.fluid;
    }

    public boolean flipFlowsIfPressureReversed() {
        if (!this.hasFlow()) {
            return false;
        }
        boolean singlePressure = this.comparePressure() != 0.0f && (this.getInboundPressure() == 0.0f || this.getOutwardPressure() == 0.0f);
        Flow flow = this.flow.get();
        if (!singlePressure || this.comparePressure() < 0.0f == flow.inbound) {
            return false;
        }
        boolean bl = flow.inbound = !flow.inbound;
        if (!flow.complete) {
            this.flow = Optional.empty();
        }
        return true;
    }

    public void manageSource(World world, BlockPos pos) {
        if (!this.source.isPresent() && !this.determineSource(world, pos)) {
            return;
        }
        FlowSource flowSource = this.source.get();
        flowSource.manageSource(world);
    }

    public boolean manageFlows(World world, BlockPos pos, FluidStack internalFluid, Predicate<FluidStack> extractionPredicate) {
        FluidStack provided;
        Optional<FluidNetwork> retainedNetwork = this.network;
        this.network = Optional.empty();
        if (!this.source.isPresent() && !this.determineSource(world, pos)) {
            return false;
        }
        FlowSource flowSource = this.source.get();
        if (!this.hasFlow()) {
            if (!this.hasPressure()) {
                return false;
            }
            boolean prioritizeInbound = this.comparePressure() < 0.0f;
            for (boolean trueFalse : Iterate.trueAndFalse) {
                boolean inbound;
                boolean bl = inbound = prioritizeInbound == trueFalse;
                if (this.pressure.get(inbound).floatValue() == 0.0f || !this.tryStartingNewFlow(inbound, inbound ? flowSource.provideFluid(extractionPredicate) : internalFluid)) continue;
                return true;
            }
            return false;
        }
        Flow flow = this.flow.get();
        FluidStack fluidStack = provided = flow.inbound ? flowSource.provideFluid(extractionPredicate) : internalFluid;
        if (!this.hasPressure() || provided.isEmpty() || !provided.isFluidEqual(flow.fluid)) {
            this.flow = Optional.empty();
            return true;
        }
        if (flow.inbound != this.comparePressure() < 0.0f) {
            boolean inbound;
            boolean bl = inbound = !flow.inbound;
            if (inbound && !provided.isEmpty() || !inbound && !internalFluid.isEmpty()) {
                FluidPropagator.resetAffectedFluidNetworks(world, pos, this.side);
                this.tryStartingNewFlow(inbound, inbound ? flowSource.provideFluid(extractionPredicate) : internalFluid);
                return true;
            }
        }
        flowSource.whileFlowPresent(world, flow.inbound);
        if (!flowSource.isEndpoint()) {
            return false;
        }
        if (!flow.inbound) {
            return false;
        }
        this.network = retainedNetwork;
        if (!this.hasNetwork()) {
            this.network = Optional.of(new FluidNetwork(world, new BlockFace(pos, this.side), flowSource::provideHandler));
        }
        this.network.get().tick();
        return false;
    }

    private boolean tryStartingNewFlow(boolean inbound, FluidStack providedFluid) {
        if (providedFluid.isEmpty()) {
            return false;
        }
        Flow flow = new Flow(inbound, providedFluid);
        this.flow = Optional.of(flow);
        return true;
    }

    private boolean determineSource(World world, BlockPos pos) {
        if (!world.isAreaLoaded(pos, 1)) {
            return false;
        }
        BlockFace location = new BlockFace(pos, this.side);
        if (FluidPropagator.isOpenEnd((IBlockReader)world, pos, this.side)) {
            this.source = this.previousSource.orElse(null) instanceof OpenEndedPipe ? this.previousSource : Optional.of(new OpenEndedPipe(location));
            return true;
        }
        if (FluidPropagator.hasFluidCapability((IBlockReader)world, location.getConnectedPos(), this.side.func_176734_d())) {
            this.source = Optional.of(new FlowSource.FluidHandler(location));
            return true;
        }
        FluidTransportBehaviour behaviour = TileEntityBehaviour.get((IBlockReader)world, pos.func_177972_a(this.side), FluidTransportBehaviour.TYPE);
        this.source = Optional.of(behaviour == null ? new FlowSource.Blocked(location) : new FlowSource.OtherPipe(location));
        return true;
    }

    public void tickFlowProgress(World world, BlockPos pos) {
        if (!this.hasFlow()) {
            return;
        }
        Flow flow = this.flow.get();
        if (flow.fluid.isEmpty()) {
            return;
        }
        if (world.field_72995_K) {
            if (!this.source.isPresent()) {
                this.determineSource(world, pos);
            }
            this.spawnParticles(world, pos, flow.fluid);
            if (this.particleSplashNextTick) {
                this.spawnSplashOnRim(world, pos, flow.fluid);
            }
            this.particleSplashNextTick = false;
        }
        float flowSpeed = 0.03125f + MathHelper.func_76131_a((float)(this.pressure.get(flow.inbound).floatValue() / 512.0f), (float)0.0f, (float)1.0f) * 31.0f / 32.0f;
        flow.progress.setValue(Math.min(flow.progress.getValue() + flowSpeed, 1.0f));
        if (flow.progress.getValue() >= 1.0f) {
            flow.complete = true;
            if (flow.inbound && AllBlocks.GLASS_FLUID_PIPE.has(world.func_180495_p(pos))) {
                AllTriggers.triggerForNearbyPlayers(AllTriggers.GLASS_PIPE, world, pos, 5);
            }
        }
    }

    public void serializeNBT(CompoundNBT tag, boolean clientPacket) {
        CompoundNBT connectionData = new CompoundNBT();
        tag.func_218657_a(this.side.func_176610_l(), (INBT)connectionData);
        if (this.hasPressure()) {
            ListNBT pressureData = new ListNBT();
            pressureData.add((Object)FloatNBT.func_229689_a_((float)this.getInboundPressure()));
            pressureData.add((Object)FloatNBT.func_229689_a_((float)this.getOutwardPressure()));
            connectionData.func_218657_a("Pressure", (INBT)pressureData);
        }
        if (this.hasOpenEnd()) {
            connectionData.func_218657_a("OpenEnd", (INBT)((OpenEndedPipe)this.source.get()).serializeNBT());
        }
        if (this.hasFlow()) {
            CompoundNBT flowData = new CompoundNBT();
            Flow flow = this.flow.get();
            flow.fluid.writeToNBT(flowData);
            flowData.func_74757_a("In", flow.inbound);
            if (!flow.complete) {
                flowData.func_218657_a("Progress", (INBT)flow.progress.writeNBT());
            }
            connectionData.func_218657_a("Flow", (INBT)flowData);
        }
    }

    private boolean hasOpenEnd() {
        return this.source.orElse(null) instanceof OpenEndedPipe;
    }

    public void deserializeNBT(CompoundNBT tag, boolean clientPacket) {
        CompoundNBT connectionData = tag.func_74775_l(this.side.func_176610_l());
        if (connectionData.func_74764_b("Pressure")) {
            ListNBT pressureData = connectionData.func_150295_c("Pressure", 5);
            this.pressure = Couple.create(Float.valueOf(pressureData.func_150308_e(0)), Float.valueOf(pressureData.func_150308_e(1)));
        } else {
            this.pressure.replace(f -> Float.valueOf(0.0f));
        }
        this.source = Optional.empty();
        if (connectionData.func_74764_b("OpenEnd")) {
            this.source = Optional.of(OpenEndedPipe.fromNBT(connectionData.func_74775_l("OpenEnd")));
        }
        if (connectionData.func_74764_b("Flow")) {
            CompoundNBT flowData = connectionData.func_74775_l("Flow");
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)flowData);
            boolean inbound = flowData.func_74767_n("In");
            if (!this.flow.isPresent()) {
                this.flow = Optional.of(new Flow(inbound, fluid));
                if (clientPacket) {
                    this.particleSplashNextTick = true;
                }
            }
            Flow flow = this.flow.get();
            flow.fluid = fluid;
            flow.inbound = inbound;
            boolean bl = flow.complete = !flowData.func_74764_b("Progress");
            if (!flow.complete) {
                flow.progress.readNBT(flowData.func_74775_l("Progress"), clientPacket);
            } else {
                if (flow.progress.getValue() == 0.0f) {
                    flow.progress.startWithValue(1.0);
                }
                flow.progress.setValue(1.0);
            }
        } else {
            this.flow = Optional.empty();
        }
    }

    public float comparePressure() {
        return this.getOutwardPressure() - this.getInboundPressure();
    }

    public void wipePressure() {
        this.pressure.replace(f -> Float.valueOf(0.0f));
        if (this.source.isPresent()) {
            this.previousSource = this.source;
        }
        this.source = Optional.empty();
        this.resetNetwork();
    }

    public FluidStack provideOutboundFlow() {
        if (!this.hasFlow()) {
            return FluidStack.EMPTY;
        }
        Flow flow = this.flow.get();
        if (!flow.complete || flow.inbound) {
            return FluidStack.EMPTY;
        }
        return flow.fluid;
    }

    public void addPressure(boolean inbound, float pressure) {
        this.pressure = this.pressure.mapWithContext((f, in) -> Float.valueOf(in == inbound ? f.floatValue() + pressure : f.floatValue()));
    }

    public boolean hasPressure() {
        return this.getInboundPressure() != 0.0f || this.getOutwardPressure() != 0.0f;
    }

    private float getOutwardPressure() {
        return ((Float)this.pressure.getSecond()).floatValue();
    }

    private float getInboundPressure() {
        return ((Float)this.pressure.getFirst()).floatValue();
    }

    public boolean hasFlow() {
        return this.flow.isPresent();
    }

    public boolean hasNetwork() {
        return this.network.isPresent();
    }

    public void resetNetwork() {
        this.network.ifPresent(FluidNetwork::reset);
    }

    public void spawnSplashOnRim(World world, BlockPos pos, FluidStack fluid) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.spawnSplashOnRimInner(world, pos, fluid));
    }

    public void spawnParticles(World world, BlockPos pos, FluidStack fluid) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.spawnParticlesInner(world, pos, fluid));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticlesInner(World world, BlockPos pos, FluidStack fluid) {
        if (!PipeConnection.isRenderEntityWithinDistance(pos)) {
            return;
        }
        if (this.hasOpenEnd()) {
            this.spawnPouringLiquid(world, pos, fluid, 1);
        } else if (r.nextFloat() < 0.001f) {
            this.spawnRimParticles(world, pos, fluid, 1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnSplashOnRimInner(World world, BlockPos pos, FluidStack fluid) {
        if (!PipeConnection.isRenderEntityWithinDistance(pos)) {
            return;
        }
        this.spawnRimParticles(world, pos, fluid, 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnRimParticles(World world, BlockPos pos, FluidStack fluid, int amount) {
        if (this.hasOpenEnd()) {
            this.spawnPouringLiquid(world, pos, fluid, amount);
            return;
        }
        IParticleData particle = FluidFX.getDrippingParticle(fluid);
        FluidFX.spawnRimParticles(world, pos, this.side, amount, particle, 0.265625f);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnPouringLiquid(World world, BlockPos pos, FluidStack fluid, int amount) {
        IParticleData particle = FluidFX.getFluidParticle(fluid);
        Vec3d directionVec = new Vec3d(this.side.func_176730_m());
        if (!this.hasFlow()) {
            return;
        }
        Flow flow = this.flow.get();
        FluidFX.spawnPouringLiquid(world, pos, amount, particle, 0.265625f, directionVec, flow.inbound);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isRenderEntityWithinDistance(BlockPos pos) {
        Entity renderViewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (renderViewEntity == null) {
            return false;
        }
        Vec3d center = VecHelper.getCenterOf((Vec3i)pos);
        return !(renderViewEntity.func_213303_ch().func_72438_d(center) > 20.0);
    }

    public class Flow {
        public boolean complete;
        public boolean inbound;
        public LerpedFloat progress;
        public FluidStack fluid;

        public Flow(boolean inbound, FluidStack fluid) {
            this.inbound = inbound;
            this.fluid = fluid;
            this.progress = LerpedFloat.linear().startWithValue(0.0);
            this.complete = false;
        }
    }
}

