/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.actors;

import com.simibubi.create.content.contraptions.fluids.actors.FluidManipulationBehaviour;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class FluidDrainingBehaviour
extends FluidManipulationBehaviour {
    Fluid fluid;
    Set<BlockPos> validationSet;
    PriorityQueue<FluidManipulationBehaviour.BlockPosEntry> queue;
    boolean isValid;
    List<FluidManipulationBehaviour.BlockPosEntry> validationFrontier;
    Set<BlockPos> validationVisited = new HashSet<BlockPos>();
    Set<BlockPos> newValidationSet;
    public static BehaviourType<FluidDrainingBehaviour> TYPE = new BehaviourType();

    public FluidDrainingBehaviour(SmartTileEntity te) {
        super(te);
        this.validationFrontier = new ArrayList<FluidManipulationBehaviour.BlockPosEntry>();
        this.validationSet = new HashSet<BlockPos>();
        this.newValidationSet = new HashSet<BlockPos>();
        this.queue = new ObjectHeapPriorityQueue(this::comparePositions);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public boolean pullNext(BlockPos root, boolean simulate) {
        if (!this.frontier.isEmpty()) {
            return false;
        }
        if (!Objects.equals(root, this.rootPos)) {
            this.rebuildContext(root);
            return false;
        }
        if (this.counterpartActed) {
            this.counterpartActed = false;
            this.softReset(root);
            return false;
        }
        if (this.affectedArea == null) {
            this.affectedArea = new MutableBoundingBox((Vec3i)root, (Vec3i)root);
        }
        World world = this.getWorld();
        if (!this.queue.isEmpty() && !this.isValid) {
            this.rebuildContext(root);
            return false;
        }
        if (this.validationFrontier.isEmpty() && !this.queue.isEmpty() && !simulate && this.revalidateIn == 0) {
            this.revalidate(root);
        }
        while (!this.queue.isEmpty()) {
            Fluid fluid;
            BlockState emptied;
            BlockPos currentPos;
            block19: {
                BlockState blockState;
                currentPos = ((FluidManipulationBehaviour.BlockPosEntry)this.queue.first()).pos;
                emptied = blockState = world.func_180495_p(currentPos);
                fluid = Fluids.field_204541_a;
                if (blockState.func_196959_b((IProperty)BlockStateProperties.field_208198_y) && ((Boolean)blockState.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue()) {
                    emptied = (BlockState)blockState.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false));
                    fluid = Fluids.field_204546_a;
                } else {
                    if (blockState.func_177230_c() instanceof FlowingFluidBlock) {
                        FlowingFluidBlock flowingFluid = (FlowingFluidBlock)blockState.func_177230_c();
                        emptied = Blocks.field_150350_a.func_176223_P();
                        if ((Integer)blockState.func_177229_b((IProperty)FlowingFluidBlock.field_176367_b) == 0) {
                            fluid = flowingFluid.getFluid();
                            break block19;
                        } else {
                            this.affectedArea.func_78888_b(new MutableBoundingBox((Vec3i)currentPos, (Vec3i)currentPos));
                            world.func_180501_a(currentPos, emptied, 18);
                            this.queue.dequeue();
                            if (!this.queue.isEmpty()) continue;
                            this.isValid = this.checkValid(world, this.rootPos);
                            this.reset();
                            continue;
                        }
                    }
                    if (blockState.func_204520_s().func_206886_c() != Fluids.field_204541_a && blockState.func_215685_b((IBlockReader)world, currentPos, ISelectionContext.func_216377_a()).func_197766_b()) {
                        fluid = blockState.func_204520_s().func_206886_c();
                        emptied = Blocks.field_150350_a.func_176223_P();
                    }
                }
            }
            if (this.fluid == null) {
                this.fluid = fluid;
            }
            if (!this.fluid.func_207187_a(fluid)) {
                this.queue.dequeue();
                if (!this.queue.isEmpty()) continue;
                this.isValid = this.checkValid(world, this.rootPos);
                this.reset();
                continue;
            }
            if (simulate) {
                return true;
            }
            this.playEffect(world, currentPos, fluid, true);
            AllTriggers.triggerForNearbyPlayers(AllTriggers.HOSE_PULLEY, world, this.tileEntity.func_174877_v(), 8);
            if (this.infinite) {
                AllTriggers.triggerForNearbyPlayers(AllTriggers.INFINITE_FLUID.constructTriggerFor(FluidHelper.convertToStill(fluid)), world, this.tileEntity.func_174877_v(), 8);
                return true;
            }
            world.func_180501_a(currentPos, emptied, 18);
            this.affectedArea.func_78888_b(new MutableBoundingBox((Vec3i)currentPos, (Vec3i)currentPos));
            this.queue.dequeue();
            if (this.queue.isEmpty()) {
                this.isValid = this.checkValid(world, this.rootPos);
                this.reset();
                return true;
            }
            if (this.validationSet.contains(currentPos)) return true;
            this.reset();
            return true;
        }
        if (this.rootPos == null) {
            return false;
        }
        if (!this.isValid) return false;
        this.rebuildContext(root);
        return false;
    }

    protected void softReset(BlockPos root) {
        this.queue.clear();
        this.validationSet.clear();
        this.newValidationSet.clear();
        this.validationFrontier.clear();
        this.validationVisited.clear();
        this.visited.clear();
        this.infinite = false;
        this.setValidationTimer();
        this.frontier.add(new FluidManipulationBehaviour.BlockPosEntry(root, 0));
        this.tileEntity.sendData();
    }

    protected boolean checkValid(World world, BlockPos root) {
        BlockPos currentPos = root;
        for (int timeout = 1000; timeout > 0 && !root.equals((Object)this.tileEntity.func_174877_v()); --timeout) {
            FluidBlockType canPullFluidsFrom = this.canPullFluidsFrom(world.func_180495_p(currentPos), currentPos);
            if (canPullFluidsFrom != FluidBlockType.FLOWING) {
                if (canPullFluidsFrom != FluidBlockType.SOURCE) break;
                return true;
            }
            currentPos = currentPos.func_177984_a();
        }
        return false;
    }

    @Override
    public void read(CompoundNBT nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (!clientPacket && this.affectedArea != null) {
            this.frontier.add(new FluidManipulationBehaviour.BlockPosEntry(this.rootPos, 0));
        }
    }

    protected FluidBlockType canPullFluidsFrom(BlockState blockState, BlockPos pos) {
        if (blockState.func_196959_b((IProperty)BlockStateProperties.field_208198_y) && ((Boolean)blockState.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue()) {
            return FluidBlockType.SOURCE;
        }
        if (blockState.func_177230_c() instanceof FlowingFluidBlock) {
            return (Integer)blockState.func_177229_b((IProperty)FlowingFluidBlock.field_176367_b) == 0 ? FluidBlockType.SOURCE : FluidBlockType.FLOWING;
        }
        if (blockState.func_204520_s().func_206886_c() != Fluids.field_204541_a && blockState.func_215685_b((IBlockReader)this.getWorld(), pos, ISelectionContext.func_216377_a()).func_197766_b()) {
            return FluidBlockType.SOURCE;
        }
        return FluidBlockType.NONE;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.rootPos != null) {
            this.isValid = this.checkValid(this.getWorld(), this.rootPos);
        }
        if (!this.frontier.isEmpty()) {
            this.continueSearch();
            return;
        }
        if (!this.validationFrontier.isEmpty()) {
            this.continueValidation();
            return;
        }
        if (this.revalidateIn > 0) {
            --this.revalidateIn;
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
    }

    public void rebuildContext(BlockPos root) {
        this.reset();
        this.rootPos = root;
        this.affectedArea = new MutableBoundingBox((Vec3i)this.rootPos, (Vec3i)this.rootPos);
        if (this.isValid) {
            this.frontier.add(new FluidManipulationBehaviour.BlockPosEntry(root, 0));
        }
    }

    public void revalidate(BlockPos root) {
        this.validationFrontier.clear();
        this.validationVisited.clear();
        this.newValidationSet.clear();
        this.validationFrontier.add(new FluidManipulationBehaviour.BlockPosEntry(root, 0));
        this.setValidationTimer();
    }

    private void continueSearch() {
        this.fluid = this.search(this.fluid, this.frontier, this.visited, (e, d) -> {
            this.queue.enqueue((Object)new FluidManipulationBehaviour.BlockPosEntry((BlockPos)e, (int)d));
            this.validationSet.add((BlockPos)e);
        }, false);
        World world = this.getWorld();
        int maxBlocks = this.maxBlocks();
        if (this.visited.size() > maxBlocks && this.canDrainInfinitely(this.fluid)) {
            BlockPos first;
            this.infinite = true;
            while (this.canPullFluidsFrom(world.func_180495_p(first = ((FluidManipulationBehaviour.BlockPosEntry)this.queue.first()).pos), first) != FluidBlockType.SOURCE) {
                this.queue.dequeue();
            }
            BlockPos firstValid = ((FluidManipulationBehaviour.BlockPosEntry)this.queue.first()).pos;
            this.frontier.clear();
            this.visited.clear();
            this.queue.clear();
            this.queue.enqueue((Object)new FluidManipulationBehaviour.BlockPosEntry(firstValid, 0));
            this.tileEntity.sendData();
            return;
        }
        if (!this.frontier.isEmpty()) {
            return;
        }
        this.tileEntity.sendData();
        this.visited.clear();
    }

    private void continueValidation() {
        this.search(this.fluid, this.validationFrontier, this.validationVisited, (e, d) -> this.newValidationSet.add((BlockPos)e), false);
        int maxBlocks = this.maxBlocks();
        if (this.validationVisited.size() > maxBlocks && this.canDrainInfinitely(this.fluid)) {
            if (!this.infinite) {
                this.reset();
            }
            this.validationFrontier.clear();
            this.setLongValidationTimer();
            return;
        }
        if (!this.validationFrontier.isEmpty()) {
            return;
        }
        if (this.infinite) {
            this.reset();
            return;
        }
        this.validationSet = this.newValidationSet;
        this.newValidationSet = new HashSet<BlockPos>();
        this.validationVisited.clear();
    }

    @Override
    public void reset() {
        super.reset();
        this.fluid = null;
        this.rootPos = null;
        this.queue.clear();
        this.validationSet.clear();
        this.newValidationSet.clear();
        this.validationFrontier.clear();
        this.validationVisited.clear();
        this.tileEntity.sendData();
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    protected boolean isSearching() {
        return !this.frontier.isEmpty();
    }

    public FluidStack getDrainableFluid(BlockPos rootPos) {
        return this.fluid == null || this.isSearching() || !this.pullNext(rootPos, true) ? FluidStack.EMPTY : new FluidStack(this.fluid, 1000);
    }

    static enum FluidBlockType {
        NONE,
        SOURCE,
        FLOWING;

    }
}

