/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.actors;

import com.simibubi.create.content.contraptions.fluids.actors.ItemDrainItemHandler;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.processing.EmptyingByBasin;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemDrainTileEntity
extends SmartTileEntity
implements IHaveGoggleInformation {
    public static final int FILLING_TIME = 20;
    SmartFluidTankBehaviour internalTank;
    TransportedItemStack heldItem;
    protected int processingTicks;
    Map<Direction, LazyOptional<ItemDrainItemHandler>> itemHandlers = new IdentityHashMap<Direction, LazyOptional<ItemDrainItemHandler>>();

    public ItemDrainTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        for (Direction d : Iterate.horizontalDirections) {
            ItemDrainItemHandler itemDrainItemHandler = new ItemDrainItemHandler(this, d);
            this.itemHandlers.put(d, (LazyOptional<ItemDrainItemHandler>)LazyOptional.of(() -> itemDrainItemHandler));
        }
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this).allowingBeltFunnels().setInsertionHandler(this::tryInsertingFromSide));
        this.internalTank = SmartFluidTankBehaviour.single(this, 1500).allowExtraction().forbidInsertion();
        behaviours.add(this.internalTank);
    }

    private ItemStack tryInsertingFromSide(TransportedItemStack transportedStack, Direction side, boolean simulate) {
        ItemStack inserted = transportedStack.stack;
        ItemStack returned = ItemStack.field_190927_a;
        if (!this.getHeldItemStack().func_190926_b()) {
            return inserted;
        }
        if (inserted.func_190916_E() > 1 && EmptyingByBasin.canItemBeEmptied(this.field_145850_b, inserted)) {
            returned = ItemHandlerHelper.copyStackWithSize((ItemStack)inserted, (int)(inserted.func_190916_E() - 1));
            inserted = ItemHandlerHelper.copyStackWithSize((ItemStack)inserted, (int)1);
        }
        if (simulate) {
            return returned;
        }
        transportedStack = transportedStack.copy();
        transportedStack.beltPosition = side.func_176740_k().func_200128_b() ? 0.5f : 0.0f;
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        this.setHeldItem(transportedStack, side);
        this.func_70296_d();
        this.sendData();
        return returned;
    }

    public ItemStack getHeldItemStack() {
        return this.heldItem == null ? ItemStack.field_190927_a : this.heldItem.stack;
    }

    @Override
    public void func_73660_a() {
        boolean onClient;
        super.func_73660_a();
        if (this.heldItem == null) {
            this.processingTicks = 0;
            return;
        }
        boolean bl = onClient = this.field_145850_b.field_72995_K && !this.isVirtual();
        if (this.processingTicks > 0) {
            boolean wasAtBeginning;
            this.heldItem.prevBeltPosition = 0.5f;
            boolean bl2 = wasAtBeginning = this.processingTicks == 20;
            if (!onClient || this.processingTicks < 20) {
                --this.processingTicks;
            }
            if (!this.continueProcessing()) {
                this.processingTicks = 0;
                this.notifyUpdate();
                return;
            }
            if (wasAtBeginning != (this.processingTicks == 20)) {
                this.sendData();
            }
            return;
        }
        this.heldItem.prevBeltPosition = this.heldItem.beltPosition;
        this.heldItem.prevSideOffset = this.heldItem.sideOffset;
        this.heldItem.beltPosition += this.itemMovementPerTick();
        if (this.heldItem.beltPosition > 1.0f) {
            BlockPos nextPosition;
            DirectBeltInputBehaviour directBeltInputBehaviour;
            this.heldItem.beltPosition = 1.0f;
            if (onClient) {
                return;
            }
            Direction side = this.heldItem.insertedFrom;
            ItemStack tryExportingToBeltFunnel = this.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(this.heldItem.stack, side.func_176734_d(), false);
            if (tryExportingToBeltFunnel != null) {
                if (tryExportingToBeltFunnel.func_190916_E() != this.heldItem.stack.func_190916_E()) {
                    if (tryExportingToBeltFunnel.func_190926_b()) {
                        this.heldItem = null;
                    } else {
                        this.heldItem.stack = tryExportingToBeltFunnel;
                    }
                    this.notifyUpdate();
                    return;
                }
                if (!tryExportingToBeltFunnel.func_190926_b()) {
                    return;
                }
            }
            if ((directBeltInputBehaviour = TileEntityBehaviour.get((IBlockReader)this.field_145850_b, nextPosition = this.field_174879_c.func_177972_a(side), DirectBeltInputBehaviour.TYPE)) == null) {
                if (!Block.func_220056_d((BlockState)this.field_145850_b.func_180495_p(nextPosition), (IBlockReader)this.field_145850_b, (BlockPos)nextPosition, (Direction)side.func_176734_d())) {
                    ItemStack ejected = this.heldItem.stack;
                    Vec3d outPos = VecHelper.getCenterOf((Vec3i)this.field_174879_c).func_178787_e(new Vec3d(side.func_176730_m()).func_186678_a(0.75));
                    float movementSpeed = this.itemMovementPerTick();
                    Vec3d outMotion = new Vec3d(side.func_176730_m()).func_186678_a((double)movementSpeed).func_72441_c(0.0, 0.125, 0.0);
                    outPos.func_178787_e(outMotion.func_72432_b());
                    ItemEntity entity = new ItemEntity(this.field_145850_b, outPos.field_72450_a, outPos.field_72448_b + 0.375, outPos.field_72449_c, ejected);
                    entity.func_213317_d(outMotion);
                    entity.func_174869_p();
                    entity.field_70133_I = true;
                    this.field_145850_b.func_217376_c((Entity)entity);
                    this.heldItem = null;
                    this.notifyUpdate();
                }
                return;
            }
            if (!directBeltInputBehaviour.canInsertFromSide(side)) {
                return;
            }
            ItemStack returned = directBeltInputBehaviour.handleInsertion(this.heldItem.copy(), side, false);
            if (returned.func_190926_b()) {
                if (this.field_145850_b.func_175625_s(nextPosition) instanceof ItemDrainTileEntity) {
                    AllTriggers.triggerForNearbyPlayers(AllTriggers.CHAINED_ITEM_DRAIN, this.field_145850_b, this.field_174879_c, 5);
                }
                this.heldItem = null;
                this.notifyUpdate();
                return;
            }
            if (returned.func_190916_E() != this.heldItem.stack.func_190916_E()) {
                this.heldItem.stack = returned;
                this.notifyUpdate();
                return;
            }
            return;
        }
        if (this.heldItem.prevBeltPosition < 0.5f && this.heldItem.beltPosition >= 0.5f) {
            if (!EmptyingByBasin.canItemBeEmptied(this.field_145850_b, this.heldItem.stack)) {
                return;
            }
            this.heldItem.beltPosition = 0.5f;
            if (onClient) {
                return;
            }
            this.processingTicks = 20;
            this.sendData();
        }
    }

    protected boolean continueProcessing() {
        if (this.field_145850_b.field_72995_K && !this.isVirtual()) {
            return true;
        }
        if (this.processingTicks < 5) {
            return true;
        }
        if (!EmptyingByBasin.canItemBeEmptied(this.field_145850_b, this.heldItem.stack)) {
            return false;
        }
        Pair<FluidStack, ItemStack> emptyItem = EmptyingByBasin.emptyItem(this.field_145850_b, this.heldItem.stack, true);
        FluidStack fluidFromItem = emptyItem.getFirst();
        if (this.processingTicks > 5) {
            this.internalTank.allowInsertion();
            if (this.internalTank.getPrimaryHandler().fill(fluidFromItem, IFluidHandler.FluidAction.SIMULATE) != fluidFromItem.getAmount()) {
                this.internalTank.forbidInsertion();
                this.processingTicks = 20;
                return true;
            }
            this.internalTank.forbidInsertion();
            return true;
        }
        emptyItem = EmptyingByBasin.emptyItem(this.field_145850_b, this.heldItem.stack.func_77946_l(), false);
        AllTriggers.triggerForNearbyPlayers(AllTriggers.ITEM_DRAIN, this.field_145850_b, this.field_174879_c, 5);
        ItemStack out = emptyItem.getSecond();
        if (!out.func_190926_b()) {
            this.heldItem.stack = out;
        } else {
            this.heldItem = null;
        }
        this.internalTank.allowInsertion();
        this.internalTank.getPrimaryHandler().fill(fluidFromItem, IFluidHandler.FluidAction.EXECUTE);
        this.internalTank.forbidInsertion();
        this.notifyUpdate();
        return true;
    }

    private float itemMovementPerTick() {
        return 0.125f;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        for (LazyOptional<ItemDrainItemHandler> lazyOptional : this.itemHandlers.values()) {
            lazyOptional.invalidate();
        }
    }

    public void setHeldItem(TransportedItemStack heldItem, Direction insertedFrom) {
        this.heldItem = heldItem;
        this.heldItem.insertedFrom = insertedFrom;
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_74768_a("ProcessingTicks", this.processingTicks);
        if (this.heldItem != null) {
            compound.func_218657_a("HeldItem", (INBT)this.heldItem.serializeNBT());
        }
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundNBT compound, boolean clientPacket) {
        this.heldItem = null;
        this.processingTicks = compound.func_74762_e("ProcessingTicks");
        if (compound.func_74764_b("HeldItem")) {
            this.heldItem = TransportedItemStack.read(compound.func_74775_l("HeldItem"));
        }
        super.read(compound, clientPacket);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (side != null && side.func_176740_k().func_176722_c() && this.isItemHandlerCap(cap)) {
            return this.itemHandlers.get(side).cast();
        }
        if (side != Direction.UP && this.isFluidHandlerCap(cap)) {
            return this.internalTank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean addToGoggleTooltip(List<String> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY));
    }
}

