/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.pipes;

import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.fluids.FluidPropagator;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.IAxisPipe;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class FluidValveBlock
extends DirectionalAxisKineticBlock
implements IAxisPipe {
    public static final BooleanProperty ENABLED = BooleanProperty.func_177716_a((String)"enabled");

    public FluidValveBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return AllShapes.FLUID_VALVE.get(FluidValveBlock.getPipeAxis(state));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a((StateContainer.Builder<Block, BlockState>)builder.func_206894_a(new IProperty[]{ENABLED}));
    }

    @Override
    protected boolean prefersConnectionTo(IWorldReader reader, BlockPos pos, Direction facing, boolean shaftAxis) {
        if (!shaftAxis) {
            BlockPos offset = pos.func_177972_a(facing);
            BlockState blockState = reader.func_180495_p(offset);
            return FluidPipeBlock.canConnectTo((ILightReader)reader, offset, blockState, facing);
        }
        return super.prefersConnectionTo(reader, pos, facing, shaftAxis);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.FLUID_VALVE.create();
    }

    @Nonnull
    public static Direction.Axis getPipeAxis(BlockState state) {
        if (!(state.func_177230_c() instanceof FluidValveBlock)) {
            throw new IllegalStateException("Provided BlockState is for a different block.");
        }
        Direction facing = (Direction)state.func_177229_b((IProperty)FACING);
        boolean alongFirst = (Boolean)state.func_177229_b((IProperty)AXIS_ALONG_FIRST_COORDINATE) == false;
        for (Direction.Axis axis : Iterate.axes) {
            if (axis == facing.func_176740_k()) continue;
            if (!alongFirst) {
                alongFirst = true;
                continue;
            }
            return axis;
        }
        throw new IllegalStateException("Impossible axis.");
    }

    @Override
    public Direction.Axis getAxis(BlockState state) {
        return FluidValveBlock.getPipeAxis(state);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        boolean blockTypeChanged;
        boolean bl = blockTypeChanged = state.func_177230_c() != newState.func_177230_c();
        if (blockTypeChanged && !world.field_72995_K) {
            FluidPropagator.propagateChangedPipe((IWorld)world, pos, state);
        }
        if (state.hasTileEntity() && (blockTypeChanged || !newState.hasTileEntity())) {
            world.func_175713_t(pos);
        }
    }

    public boolean func_196260_a(BlockState p_196260_1_, IWorldReader p_196260_2_, BlockPos p_196260_3_) {
        return true;
    }

    @Override
    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (world.field_72995_K) {
            return;
        }
        if (state != oldState) {
            world.func_205220_G_().func_205362_a(pos, (Object)this, 1, TickPriority.HIGH);
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block otherBlock, BlockPos neighborPos, boolean isMoving) {
        DebugPacketSender.func_218806_a((World)world, (BlockPos)pos);
        Direction d = FluidPropagator.validateNeighbourChange(state, world, pos, otherBlock, neighborPos, isMoving);
        if (d == null) {
            return;
        }
        if (!FluidValveBlock.isOpenAt(state, d)) {
            return;
        }
        world.func_205220_G_().func_205362_a(pos, (Object)this, 1, TickPriority.HIGH);
    }

    public static boolean isOpenAt(BlockState state, Direction d) {
        return d.func_176740_k() == FluidValveBlock.getPipeAxis(state);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random r) {
        FluidPropagator.propagateChangedPipe((IWorld)world, pos, state);
    }
}

