/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.goggles;

import com.simibubi.create.foundation.utility.Lang;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public interface IHaveGoggleInformation {
    public static final Format numberFormat = new Format();
    public static final String spacing = "    ";

    default public boolean addToGoggleTooltip(List<String> tooltip, boolean isPlayerSneaking) {
        return false;
    }

    public static String format(double d) {
        return numberFormat.get().format(d);
    }

    default public boolean containedFluidTooltip(List<String> tooltip, boolean isPlayerSneaking, LazyOptional<IFluidHandler> handler) {
        tooltip.add(spacing + Lang.translate("gui.goggles.fluid_container", new Object[0]));
        String mb = Lang.translate("generic.unit.millibuckets", new Object[0]);
        IFluidHandler tank = (IFluidHandler)handler.orElse(null);
        if (tank == null || tank.getTanks() == 0) {
            return false;
        }
        StringTextComponent indent = new StringTextComponent("     ");
        boolean isEmpty = true;
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack fluidStack = tank.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            ITextComponent fluidName = new TranslationTextComponent(fluidStack.getTranslationKey(), new Object[0]).func_211708_a(TextFormatting.GRAY);
            ITextComponent contained = new StringTextComponent(IHaveGoggleInformation.format(fluidStack.getAmount()) + mb).func_211708_a(TextFormatting.GOLD);
            ITextComponent slash = new StringTextComponent(" / ").func_211708_a(TextFormatting.GRAY);
            ITextComponent capacity = new StringTextComponent(IHaveGoggleInformation.format(tank.getTankCapacity(i)) + mb).func_211708_a(TextFormatting.DARK_GRAY);
            tooltip.add(indent.func_212638_h().func_150257_a(fluidName).func_150254_d());
            tooltip.add(indent.func_212638_h().func_150257_a(contained).func_150257_a(slash).func_150257_a(capacity).func_150254_d());
            isEmpty = false;
        }
        if (tank.getTanks() > 1) {
            if (isEmpty) {
                tooltip.remove(tooltip.size() - 1);
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        ITextComponent capacity = new StringTextComponent(Lang.translate("gui.goggles.fluid_container.capacity", new Object[0])).func_211708_a(TextFormatting.GRAY);
        ITextComponent amount = new StringTextComponent(IHaveGoggleInformation.format(tank.getTankCapacity(0)) + mb).func_211708_a(TextFormatting.GOLD);
        String capacityString = indent.func_212638_h().func_150257_a(capacity).func_150257_a(amount).func_150254_d();
        tooltip.add(capacityString);
        return true;
    }

    public static class Format {
        private NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);

        private Format() {
        }

        public NumberFormat get() {
            return this.format;
        }

        public void update() {
            this.format = NumberFormat.getInstance(Minecraft.func_71410_x().func_135016_M().func_135041_c().getJavaLocale());
            this.format.setMaximumFractionDigits(2);
            this.format.setMinimumFractionDigits(0);
            this.format.setGroupingUsed(true);
        }
    }
}

