/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.content.contraptions.particle.CubeParticle;
import com.simibubi.create.content.contraptions.particle.ICustomParticleData;
import java.util.Locale;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CubeParticleData
implements IParticleData,
ICustomParticleData<CubeParticleData> {
    public static final IParticleData.IDeserializer<CubeParticleData> DESERIALIZER = new IParticleData.IDeserializer<CubeParticleData>(){

        public CubeParticleData deserialize(ParticleType<CubeParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            reader.expect(' ');
            float scale = reader.readFloat();
            reader.expect(' ');
            int avgAge = reader.readInt();
            reader.expect(' ');
            boolean hot = reader.readBoolean();
            return new CubeParticleData(r, g, b, scale, avgAge, hot);
        }

        public CubeParticleData read(ParticleType<CubeParticleData> type, PacketBuffer buffer) {
            return new CubeParticleData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt(), buffer.readBoolean());
        }
    };
    final float r;
    final float g;
    final float b;
    final float scale;
    final int avgAge;
    final boolean hot;

    public CubeParticleData(float r, float g, float b, float scale, int avgAge, boolean hot) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.scale = scale;
        this.avgAge = avgAge;
        this.hot = hot;
    }

    public CubeParticleData() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 0, false);
    }

    @Override
    public IParticleData.IDeserializer<CubeParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IParticleFactory<CubeParticleData> getFactory() {
        return new CubeParticle.Factory();
    }

    public ParticleType<?> func_197554_b() {
        return AllParticleTypes.CUBE.get();
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeFloat(this.r);
        buffer.writeFloat(this.g);
        buffer.writeFloat(this.b);
        buffer.writeFloat(this.scale);
        buffer.writeInt(this.avgAge);
        buffer.writeBoolean(this.hot);
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %f %f %f %f %d %s", AllParticleTypes.CUBE.parameter(), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.scale), this.avgAge, this.hot);
    }
}

