/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.content.contraptions.particle.HeaterParticle;
import com.simibubi.create.content.contraptions.particle.ICustomParticleDataWithSprite;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class HeaterParticleData
implements IParticleData,
ICustomParticleDataWithSprite<HeaterParticleData> {
    public static final IParticleData.IDeserializer<HeaterParticleData> DESERIALIZER = new IParticleData.IDeserializer<HeaterParticleData>(){

        public HeaterParticleData deserialize(ParticleType<HeaterParticleData> arg0, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            return new HeaterParticleData(r, g, b);
        }

        public HeaterParticleData read(ParticleType<HeaterParticleData> type, PacketBuffer buffer) {
            return new HeaterParticleData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    final float r;
    final float g;
    final float b;

    public HeaterParticleData(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public HeaterParticleData() {
        this(0.0f, 0.0f, 0.0f);
    }

    @Override
    public IParticleData.IDeserializer<HeaterParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ParticleManager.IParticleMetaFactory<HeaterParticleData> getMetaFactory() {
        return HeaterParticle.Factory::new;
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %f %f %f", AllParticleTypes.HEATER_PARTICLE.parameter(), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b));
    }

    public ParticleType<?> func_197554_b() {
        return AllParticleTypes.HEATER_PARTICLE.get();
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeFloat(this.r);
        buffer.writeFloat(this.g);
        buffer.writeFloat(this.b);
    }
}

