/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.advanced;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.HorizontalAxisKineticBlock;
import com.simibubi.create.content.contraptions.relays.advanced.SpeedControllerTileEntity;
import com.simibubi.create.content.contraptions.relays.elementary.CogWheelBlock;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SpeedControllerBlock
extends HorizontalAxisKineticBlock
implements ITE<SpeedControllerTileEntity> {
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public SpeedControllerBlock(Block.Properties properties) {
        super(properties);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.ROTATION_SPEED_CONTROLLER.create();
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState above = context.func_195991_k().func_180495_p(context.func_195995_a().func_177984_a());
        if (ICogWheel.isLargeCog(above) && ((Direction.Axis)above.func_177229_b((IProperty)CogWheelBlock.AXIS)).func_176722_c()) {
            return (BlockState)this.func_176223_P().func_206870_a(HORIZONTAL_AXIS, (Comparable)(above.func_177229_b((IProperty)CogWheelBlock.AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        }
        return super.func_196258_a(context);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block p_220069_4_, BlockPos neighbourPos, boolean p_220069_6_) {
        if (neighbourPos.equals((Object)pos.func_177984_a())) {
            this.withTileEntityDo((IBlockReader)world, pos, SpeedControllerTileEntity::updateBracket);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        ItemStack heldItem = player.func_184586_b(hand);
        IPlacementHelper helper = PlacementHelpers.get(placementHelperId);
        if (helper.matchesItem(heldItem)) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.func_77973_b(), player, hand, ray);
        }
        return ActionResultType.PASS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AllShapes.SPEED_CONTROLLER;
    }

    @Override
    public Class<SpeedControllerTileEntity> getTileEntityClass() {
        return SpeedControllerTileEntity.class;
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isLargeCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return AllBlocks.ROTATION_SPEED_CONTROLLER::has;
        }

        @Override
        public PlacementOffset getOffset(PlayerEntity player, World world, BlockState state, BlockPos pos, BlockRayTraceResult ray) {
            Direction.Axis newAxis;
            BlockPos newPos = pos.func_177984_a();
            if (!world.func_180495_p(newPos).func_185904_a().func_76222_j()) {
                return PlacementOffset.fail();
            }
            Direction.Axis axis = newAxis = state.func_177229_b(HorizontalAxisKineticBlock.HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
            if (!CogWheelBlock.isValidCogwheelPosition(true, (IWorldReader)world, newPos, newAxis)) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.func_206870_a((IProperty)CogWheelBlock.AXIS, (Comparable)newAxis));
        }
    }
}

