/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.advanced.sequencer;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.relays.advanced.sequencer.ConfigureSequencedGearshiftPacket;
import com.simibubi.create.content.contraptions.relays.advanced.sequencer.Instruction;
import com.simibubi.create.content.contraptions.relays.advanced.sequencer.InstructionSpeedModifiers;
import com.simibubi.create.content.contraptions.relays.advanced.sequencer.SequencedGearshiftTileEntity;
import com.simibubi.create.content.contraptions.relays.advanced.sequencer.SequencerInstructions;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.gui.widgets.ScrollInput;
import com.simibubi.create.foundation.gui.widgets.SelectionScrollInput;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;

public class SequencedGearshiftScreen
extends AbstractSimiScreen {
    private final ItemStack renderedItem = AllBlocks.SEQUENCED_GEARSHIFT.asStack();
    private final AllGuiTextures background = AllGuiTextures.SEQUENCER;
    private IconButton confirmButton;
    private final String title = Lang.translate("gui.sequenced_gearshift.title", new Object[0]);
    private ListNBT compareTag;
    private Vector<Instruction> instructions;
    private BlockPos pos;
    private Vector<Vector<ScrollInput>> inputs;

    public SequencedGearshiftScreen(SequencedGearshiftTileEntity te) {
        this.instructions = te.instructions;
        this.pos = te.func_174877_v();
        this.compareTag = Instruction.serializeAll(this.instructions);
    }

    protected void init() {
        int row;
        this.setWindowSize(this.background.width + 50, this.background.height);
        super.init();
        this.widgets.clear();
        this.inputs = new Vector(5);
        for (row = 0; row < this.inputs.capacity(); ++row) {
            this.inputs.add(new Vector(3));
        }
        for (row = 0; row < this.instructions.size(); ++row) {
            this.initInputsOfRow(row);
        }
    }

    public void initInputsOfRow(int row) {
        int x = this.guiLeft + 30;
        int y = this.guiTop + 18;
        int rowHeight = 22;
        Vector<ScrollInput> rowInputs = this.inputs.get(row);
        rowInputs.forEach(this.widgets::remove);
        rowInputs.clear();
        int index = row;
        Instruction instruction = this.instructions.get(row);
        ScrollInput type = new SelectionScrollInput(x, y + rowHeight * row, 50, 18).forOptions(SequencerInstructions.getOptions()).calling(state -> this.instructionUpdated(index, (int)state)).setState(instruction.instruction.ordinal()).titled(Lang.translate("gui.sequenced_gearshift.instruction", new Object[0]));
        ScrollInput value = new ScrollInput(x + 58, y + rowHeight * row, 28, 18).calling(state -> {
            instruction.value = state;
        });
        ScrollInput direction = new SelectionScrollInput(x + 88, y + rowHeight * row, 28, 18).forOptions(InstructionSpeedModifiers.getOptions()).calling(state -> {
            instruction.speedModifier = InstructionSpeedModifiers.values()[state];
        }).titled(Lang.translate("gui.sequenced_gearshift.speed", new Object[0]));
        rowInputs.add(type);
        rowInputs.add(value);
        rowInputs.add(direction);
        this.widgets.addAll(rowInputs);
        this.updateParamsOfRow(row);
        this.confirmButton = new IconButton(this.guiLeft + this.background.width - 33, this.guiTop + this.background.height - 24, AllIcons.I_CONFIRM);
        this.widgets.add(this.confirmButton);
    }

    public void updateParamsOfRow(int row) {
        Instruction instruction = this.instructions.get(row);
        Vector<ScrollInput> rowInputs = this.inputs.get(row);
        SequencerInstructions def = instruction.instruction;
        boolean hasValue = def.hasValueParameter;
        boolean hasModifier = def.hasSpeedParameter;
        ScrollInput value = rowInputs.get(1);
        value.active = value.visible = hasValue;
        if (hasValue) {
            value.withRange(1, def.maxValue + 1).titled(Lang.translate(def.parameterKey, new Object[0])).withShiftStep(def.shiftStep).setState(instruction.value).onChanged();
        }
        if (def == SequencerInstructions.DELAY) {
            value.withStepFunction(context -> {
                int v = context.currentValue;
                if (!context.forward) {
                    --v;
                }
                if (v < 20) {
                    return context.shift ? 20 : 1;
                }
                return context.shift ? 100 : 20;
            });
        } else {
            value.withStepFunction(value.standardStep());
        }
        ScrollInput modifier = rowInputs.get(2);
        modifier.active = modifier.visible = hasModifier;
        if (hasModifier) {
            modifier.setState(instruction.speedModifier.ordinal());
        }
    }

    @Override
    protected void renderWindow(int mouseX, int mouseY, float partialTicks) {
        this.background.draw((AbstractGui)this, this.guiLeft, this.guiTop);
        for (int row = 0; row < this.instructions.capacity(); ++row) {
            AllGuiTextures toDraw = AllGuiTextures.SEQUENCER_EMPTY;
            int yOffset = toDraw.height * row;
            if (row >= this.instructions.size()) {
                toDraw.draw(this.guiLeft, this.guiTop + 14 + yOffset);
                continue;
            }
            Instruction instruction = this.instructions.get(row);
            SequencerInstructions def = instruction.instruction;
            def.background.draw(this.guiLeft, this.guiTop + 14 + yOffset);
            this.label(36, yOffset - 3, Lang.translate(def.translationKey, new Object[0]));
            if (def.hasValueParameter) {
                String text = def.formatValue(instruction.value);
                int stringWidth = this.font.func_78256_a(text);
                this.label(90 + (12 - stringWidth / 2), yOffset - 3, text);
            }
            if (!def.hasSpeedParameter) continue;
            this.label(127, yOffset - 3, instruction.speedModifier.label);
        }
        this.font.func_175063_a(this.title, (float)(this.guiLeft - 3 + (this.background.width - this.font.func_78256_a(this.title)) / 2), (float)(this.guiTop + 3), 0xFFFFFF);
        GuiGameElement.of(this.renderedItem).at(this.guiLeft + this.background.width + 20, this.guiTop + 50).scale(5.0).render();
    }

    private void label(int x, int y, String text) {
        this.font.func_175063_a(text, (float)(this.guiLeft + x), (float)(this.guiTop + 26 + y), 0xFFFFEE);
    }

    public void sendPacket() {
        ListNBT serialized = Instruction.serializeAll(this.instructions);
        if (serialized.equals((Object)this.compareTag)) {
            return;
        }
        AllPackets.channel.sendToServer((Object)new ConfigureSequencedGearshiftPacket(this.pos, serialized));
    }

    public void removed() {
        this.sendPacket();
    }

    private void instructionUpdated(int index, int state) {
        SequencerInstructions newValue;
        this.instructions.get((int)index).instruction = newValue = SequencerInstructions.values()[state];
        this.instructions.get((int)index).value = newValue.defaultValue;
        this.updateParamsOfRow(index);
        if (newValue == SequencerInstructions.END) {
            for (int i = this.instructions.size() - 1; i > index; --i) {
                this.instructions.remove(i);
                Vector<ScrollInput> rowInputs = this.inputs.get(i);
                rowInputs.forEach(this.widgets::remove);
                rowInputs.clear();
            }
        } else if (index + 1 < this.instructions.capacity() && index + 1 == this.instructions.size()) {
            this.instructions.add(new Instruction(SequencerInstructions.END));
            this.initInputsOfRow(index + 1);
        }
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        if (this.confirmButton.isHovered()) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            return true;
        }
        return super.mouseClicked(x, y, button);
    }
}

