/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltPart;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.foundation.utility.VoxelShaper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public class BeltShapes {
    private static final VoxelShape SLOPE_DESC_PART = BeltShapes.makeSlopePart(false);
    private static final VoxelShape SLOPE_ASC_PART = BeltShapes.makeSlopePart(true);
    private static final VoxelShape SIDEWAYS_FULL_PART = BeltShapes.makeSidewaysFull();
    private static final VoxelShape SIDEWAYS_END_PART = BeltShapes.makeSidewaysEnding();
    private static final VoxelShape FLAT_FULL_PART = BeltShapes.makeFlatFull();
    private static final VoxelShape FLAT_END_PART = BeltShapes.makeFlatEnding();
    private static final VoxelShape SOUTH_MASK = Block.func_208617_a((double)0.0, (double)-5.0, (double)8.0, (double)16.0, (double)21.0, (double)16.0);
    private static final VoxelShape NORTH_MASK = Block.func_208617_a((double)0.0, (double)-5.0, (double)0.0, (double)16.0, (double)21.0, (double)8.0);
    private static final VoxelShaper VERTICAL_FULL = VerticalBeltShaper.make(FLAT_FULL_PART);
    private static final VoxelShaper VERTICAL_END = VerticalBeltShaper.make(BeltShapes.compose(FLAT_END_PART, FLAT_FULL_PART));
    private static final VoxelShaper VERTICAL_START = VerticalBeltShaper.make(BeltShapes.compose(FLAT_FULL_PART, FLAT_END_PART));
    private static final VoxelShaper FLAT_FULL = VoxelShaper.forHorizontalAxis(FLAT_FULL_PART, Direction.Axis.Z);
    private static final VoxelShaper FLAT_END = VoxelShaper.forHorizontal(BeltShapes.compose(FLAT_END_PART, FLAT_FULL_PART), Direction.SOUTH);
    private static final VoxelShaper FLAT_START = VoxelShaper.forHorizontal(BeltShapes.compose(FLAT_FULL_PART, FLAT_END_PART), Direction.SOUTH);
    private static final VoxelShaper SIDE_FULL = VoxelShaper.forHorizontalAxis(SIDEWAYS_FULL_PART, Direction.Axis.Z);
    private static final VoxelShaper SIDE_END = VoxelShaper.forHorizontal(BeltShapes.compose(SIDEWAYS_END_PART, SIDEWAYS_FULL_PART), Direction.SOUTH);
    private static final VoxelShaper SIDE_START = VoxelShaper.forHorizontal(BeltShapes.compose(SIDEWAYS_FULL_PART, SIDEWAYS_END_PART), Direction.SOUTH);
    private static final VoxelShaper SLOPE_DESC = VoxelShaper.forHorizontal(SLOPE_DESC_PART, Direction.SOUTH);
    private static final VoxelShaper SLOPE_ASC = VoxelShaper.forHorizontal(SLOPE_ASC_PART, Direction.SOUTH);
    private static final VoxelShaper SLOPE_DESC_END = VoxelShaper.forHorizontal(BeltShapes.compose(FLAT_END_PART, SLOPE_DESC_PART), Direction.SOUTH);
    private static final VoxelShaper SLOPE_DESC_START = VoxelShaper.forHorizontal(BeltShapes.compose(SLOPE_DESC_PART, FLAT_END_PART), Direction.SOUTH);
    private static final VoxelShaper SLOPE_ASC_END = VoxelShaper.forHorizontal(BeltShapes.compose(FLAT_END_PART, SLOPE_ASC_PART), Direction.SOUTH);
    private static final VoxelShaper SLOPE_ASC_START = VoxelShaper.forHorizontal(BeltShapes.compose(SLOPE_ASC_PART, FLAT_END_PART), Direction.SOUTH);
    private static final VoxelShaper PARTIAL_CASING = VoxelShaper.forHorizontal(Block.func_208617_a((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)11.0, (double)16.0), Direction.SOUTH);
    static Map<BlockState, VoxelShape> cache = new HashMap<BlockState, VoxelShape>();
    static Map<BlockState, VoxelShape> collisionCache = new HashMap<BlockState, VoxelShape>();

    private static VoxelShape compose(VoxelShape southPart, VoxelShape northPart) {
        return VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197882_b((VoxelShape)SOUTH_MASK, (VoxelShape)southPart, (IBooleanFunction)IBooleanFunction.field_223238_i_), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)NORTH_MASK, (VoxelShape)northPart, (IBooleanFunction)IBooleanFunction.field_223238_i_));
    }

    private static VoxelShape makeSlopePart(boolean ascendingInstead) {
        VoxelShape slice = Block.func_208617_a((double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)11.0, (double)15.0);
        VoxelShape result = VoxelShapes.func_197880_a();
        for (int i = 0; i < 16; ++i) {
            int yOffset = ascendingInstead ? 10 - i : i - 5;
            result = VoxelShapes.func_197872_a((VoxelShape)result, (VoxelShape)slice.func_197751_a(0.0, (double)((float)yOffset / 16.0f), (double)((float)(-i) / 16.0f)));
        }
        return result;
    }

    private static VoxelShape makeFlatEnding() {
        return VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)1.0, (double)4.0, (double)0.0, (double)15.0, (double)12.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0));
    }

    private static VoxelShape makeFlatFull() {
        return Block.func_208617_a((double)1.0, (double)3.0, (double)0.0, (double)15.0, (double)13.0, (double)16.0);
    }

    private static VoxelShape makeSidewaysEnding() {
        return VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)1.0, (double)0.0, (double)12.0, (double)15.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)3.0, (double)1.0, (double)1.0, (double)13.0, (double)15.0, (double)15.0));
    }

    private static VoxelShape makeSidewaysFull() {
        return Block.func_208617_a((double)3.0, (double)1.0, (double)0.0, (double)13.0, (double)15.0, (double)16.0);
    }

    public static VoxelShape getShape(BlockState state) {
        if (cache.containsKey(state)) {
            return cache.get(state);
        }
        VoxelShape createdShape = VoxelShapes.func_197872_a((VoxelShape)BeltShapes.getBeltShape(state), (VoxelShape)BeltShapes.getCasingShape(state));
        cache.put(state, createdShape);
        return createdShape;
    }

    public static VoxelShape getCollisionShape(BlockState state) {
        if (collisionCache.containsKey(state)) {
            return collisionCache.get(state);
        }
        VoxelShape createdShape = VoxelShapes.func_197882_b((VoxelShape)AllShapes.BELT_COLLISION_MASK, (VoxelShape)BeltShapes.getShape(state), (IBooleanFunction)IBooleanFunction.field_223238_i_);
        collisionCache.put(state, createdShape);
        return createdShape;
    }

    private static VoxelShape getBeltShape(BlockState state) {
        Direction facing = (Direction)state.func_177229_b(BeltBlock.HORIZONTAL_FACING);
        Direction.Axis axis = facing.func_176740_k();
        BeltPart part = (BeltPart)((Object)state.func_177229_b(BeltBlock.PART));
        BeltSlope slope = (BeltSlope)((Object)state.func_177229_b(BeltBlock.SLOPE));
        if (slope == BeltSlope.VERTICAL) {
            if (part == BeltPart.MIDDLE || part == BeltPart.PULLEY) {
                return VERTICAL_FULL.get(axis);
            }
            return (part == BeltPart.START ? VERTICAL_START : VERTICAL_END).get(facing);
        }
        if (slope == BeltSlope.HORIZONTAL) {
            if (part == BeltPart.MIDDLE || part == BeltPart.PULLEY) {
                return FLAT_FULL.get(axis);
            }
            return (part == BeltPart.START ? FLAT_START : FLAT_END).get(facing);
        }
        if (slope == BeltSlope.SIDEWAYS) {
            if (part == BeltPart.MIDDLE || part == BeltPart.PULLEY) {
                return SIDE_FULL.get(axis);
            }
            return (part == BeltPart.START ? SIDE_START : SIDE_END).get(facing);
        }
        if (part == BeltPart.MIDDLE || part == BeltPart.PULLEY) {
            return (slope == BeltSlope.DOWNWARD ? SLOPE_DESC : SLOPE_ASC).get(facing);
        }
        if (part == BeltPart.START) {
            return (slope == BeltSlope.DOWNWARD ? SLOPE_DESC_START : SLOPE_ASC_START).get(facing);
        }
        if (part == BeltPart.END) {
            return (slope == BeltSlope.DOWNWARD ? SLOPE_DESC_END : SLOPE_ASC_END).get(facing);
        }
        return VoxelShapes.func_197880_a();
    }

    private static VoxelShape getCasingShape(BlockState state) {
        if (!((Boolean)state.func_177229_b((IProperty)BeltBlock.CASING)).booleanValue()) {
            return VoxelShapes.func_197880_a();
        }
        Direction facing = (Direction)state.func_177229_b(BeltBlock.HORIZONTAL_FACING);
        BeltPart part = (BeltPart)((Object)state.func_177229_b(BeltBlock.PART));
        BeltSlope slope = (BeltSlope)((Object)state.func_177229_b(BeltBlock.SLOPE));
        if (slope == BeltSlope.VERTICAL) {
            return VoxelShapes.func_197880_a();
        }
        if (slope == BeltSlope.SIDEWAYS) {
            return VoxelShapes.func_197880_a();
        }
        if (slope == BeltSlope.HORIZONTAL) {
            return AllShapes.CASING_11PX.get(Direction.UP);
        }
        if (part == BeltPart.MIDDLE || part == BeltPart.PULLEY) {
            return PARTIAL_CASING.get(slope == BeltSlope.UPWARD ? facing : facing.func_176734_d());
        }
        if (part == BeltPart.START) {
            return slope == BeltSlope.UPWARD ? AllShapes.CASING_11PX.get(Direction.UP) : PARTIAL_CASING.get(facing.func_176734_d());
        }
        if (part == BeltPart.END) {
            return slope == BeltSlope.DOWNWARD ? AllShapes.CASING_11PX.get(Direction.UP) : PARTIAL_CASING.get(facing);
        }
        return VoxelShapes.func_197868_b();
    }

    private static class VerticalBeltShaper
    extends VoxelShaper {
        private VerticalBeltShaper() {
        }

        public static VoxelShaper make(VoxelShape southBeltShape) {
            return VerticalBeltShaper.forDirectionsWithRotation(VerticalBeltShaper.rotatedCopy(southBeltShape, new Vec3d(-90.0, 0.0, 0.0)), Direction.SOUTH, (Iterable<Direction>)Direction.Plane.HORIZONTAL, direction -> new Vec3d(direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? 0.0 : 180.0, (double)(-direction.func_185119_l()), 0.0));
        }
    }
}

