/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.elementary;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.relays.advanced.SpeedControllerBlock;
import com.simibubi.create.content.contraptions.relays.elementary.AbstractShaftBlock;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.foundation.utility.Iterate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CogWheelBlock
extends AbstractShaftBlock
implements ICogWheel {
    boolean isLarge;

    protected CogWheelBlock(boolean large, Block.Properties properties) {
        super(properties);
        this.isLarge = large;
    }

    public static CogWheelBlock small(Block.Properties properties) {
        return new CogWheelBlock(false, properties);
    }

    public static CogWheelBlock large(Block.Properties properties) {
        return new CogWheelBlock(true, properties);
    }

    @Override
    public boolean isLargeCog() {
        return this.isLarge;
    }

    @Override
    public boolean isSmallCog() {
        return !this.isLarge;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (this.isLarge ? AllShapes.LARGE_GEAR : AllShapes.SMALL_GEAR).get((Direction.Axis)state.func_177229_b((IProperty)AXIS));
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return CogWheelBlock.isValidCogwheelPosition(ICogWheel.isLargeCog(state), worldIn, pos, (Direction.Axis)state.func_177229_b((IProperty)AXIS));
    }

    public static boolean isValidCogwheelPosition(boolean large, IWorldReader worldIn, BlockPos pos, Direction.Axis cogAxis) {
        for (Direction facing : Iterate.directions) {
            BlockPos offsetPos;
            BlockState blockState;
            if (facing.func_176740_k() == cogAxis || (blockState = worldIn.func_180495_p(offsetPos = pos.func_177972_a(facing))).func_196959_b((IProperty)AXIS) && facing.func_176740_k() == blockState.func_177229_b((IProperty)AXIS) || !ICogWheel.isLargeCog(blockState) && (!large || !ICogWheel.isSmallCog(blockState))) continue;
            return false;
        }
        return true;
    }

    protected Direction.Axis getAxisForPlacement(BlockItemUseContext context) {
        if (context.func_195999_j() != null && context.func_195999_j().func_225608_bj_()) {
            return context.func_196000_l().func_176740_k();
        }
        World world = context.func_195991_k();
        BlockState stateBelow = world.func_180495_p(context.func_195995_a().func_177977_b());
        if (AllBlocks.ROTATION_SPEED_CONTROLLER.has(stateBelow) && this.isLargeCog()) {
            return stateBelow.func_177229_b(SpeedControllerBlock.HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        }
        BlockPos placedOnPos = context.func_195995_a().func_177972_a(context.func_196000_l().func_176734_d());
        BlockState placedAgainst = world.func_180495_p(placedOnPos);
        Block block = placedAgainst.func_177230_c();
        if (ICogWheel.isSmallCog(placedAgainst)) {
            return ((IRotate)block).getRotationAxis(placedAgainst);
        }
        Direction.Axis preferredAxis = CogWheelBlock.getPreferredAxis(context);
        return preferredAxis != null ? preferredAxis : context.func_196000_l().func_176740_k();
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean shouldWaterlog = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)AXIS, (Comparable)this.getAxisForPlacement(context))).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(shouldWaterlog));
    }

    @Override
    public float getParticleTargetRadius() {
        return this.isLargeCog() ? 1.125f : 0.65f;
    }

    @Override
    public float getParticleInitialRadius() {
        return this.isLargeCog() ? 1.0f : 0.75f;
    }

    @Override
    public boolean isDedicatedCogWheel() {
        return true;
    }
}

