/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.encased;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.contraptions.relays.encased.AdjustablePulleyTileEntity;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class EncasedBeltBlock
extends RotatedPillarKineticBlock {
    public static final IProperty<Part> PART = EnumProperty.func_177709_a((String)"part", Part.class);
    public static final BooleanProperty CONNECTED_ALONG_FIRST_COORDINATE = DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE;

    public EncasedBeltBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(PART, (Comparable)((Object)Part.NONE)));
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return false;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.NORMAL;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a((StateContainer.Builder<Block, BlockState>)builder.func_206894_a(new IProperty[]{PART, CONNECTED_ALONG_FIRST_COORDINATE}));
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction.Axis axis;
        Direction.Axis placedAxis = context.func_196010_d().func_176740_k();
        Direction.Axis axis2 = axis = context.func_195999_j() != null && context.func_195999_j().func_225608_bj_() ? placedAxis : EncasedBeltBlock.getPreferredAxis(context);
        if (axis == null) {
            axis = placedAxis;
        }
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((IProperty)AXIS, (Comparable)axis);
        for (Direction facing : Iterate.directions) {
            if (facing.func_176740_k() == axis) continue;
            BlockPos pos = context.func_195995_a();
            BlockPos offset = pos.func_177972_a(facing);
            state = this.func_196271_a(state, facing, context.func_195991_k().func_180495_p(offset), (IWorld)context.func_195991_k(), pos, offset);
        }
        return state;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction face, BlockState neighbour, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis otherConnectionAxis;
        boolean positive;
        Part part = (Part)((Object)stateIn.func_177229_b(PART));
        Direction.Axis axis = (Direction.Axis)stateIn.func_177229_b((IProperty)AXIS);
        boolean connectionAlongFirst = (Boolean)stateIn.func_177229_b((IProperty)CONNECTED_ALONG_FIRST_COORDINATE);
        Direction.Axis connectionAxis = connectionAlongFirst ? (axis == Direction.Axis.X ? Direction.Axis.Y : Direction.Axis.X) : (axis == Direction.Axis.Z ? Direction.Axis.Y : Direction.Axis.Z);
        Direction.Axis faceAxis = face.func_176740_k();
        boolean facingAlongFirst = axis == Direction.Axis.X ? faceAxis.func_200128_b() : faceAxis == Direction.Axis.X;
        boolean bl = positive = face.func_176743_c() == Direction.AxisDirection.POSITIVE;
        if (axis == faceAxis) {
            return stateIn;
        }
        if (!(neighbour.func_177230_c() instanceof EncasedBeltBlock)) {
            if (facingAlongFirst != connectionAlongFirst || part == Part.NONE) {
                return stateIn;
            }
            if (part == Part.MIDDLE) {
                return (BlockState)stateIn.func_206870_a(PART, (Comparable)((Object)(positive ? Part.END : Part.START)));
            }
            if (part == Part.START == positive) {
                return (BlockState)stateIn.func_206870_a(PART, (Comparable)((Object)Part.NONE));
            }
            return stateIn;
        }
        Part otherPart = (Part)((Object)neighbour.func_177229_b(PART));
        Direction.Axis otherAxis = (Direction.Axis)neighbour.func_177229_b((IProperty)AXIS);
        boolean otherConnection = (Boolean)neighbour.func_177229_b((IProperty)CONNECTED_ALONG_FIRST_COORDINATE);
        Direction.Axis axis2 = otherConnection ? (otherAxis == Direction.Axis.X ? Direction.Axis.Y : Direction.Axis.X) : (otherConnectionAxis = otherAxis == Direction.Axis.Z ? Direction.Axis.Y : Direction.Axis.Z);
        if (neighbour.func_177229_b((IProperty)AXIS) == faceAxis) {
            return stateIn;
        }
        if (otherPart != Part.NONE && otherConnectionAxis != faceAxis) {
            return stateIn;
        }
        if (part == Part.NONE) {
            Part part2 = part = positive ? Part.START : Part.END;
            connectionAlongFirst = axis == Direction.Axis.X ? faceAxis.func_200128_b() : faceAxis == Direction.Axis.X;
        } else if (connectionAxis != faceAxis) {
            return stateIn;
        }
        if (part == Part.START != positive) {
            part = Part.MIDDLE;
        }
        return (BlockState)((BlockState)stateIn.func_206870_a(PART, (Comparable)((Object)part))).func_206870_a((IProperty)CONNECTED_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(connectionAlongFirst));
    }

    @Override
    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        if (originalState.func_177229_b(PART) == Part.NONE) {
            return super.getRotatedBlockState(originalState, targetedFace);
        }
        return super.getRotatedBlockState(originalState, Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)EncasedBeltBlock.getConnectionAxis(originalState)));
    }

    @Override
    public BlockState updateAfterWrenched(BlockState newState, ItemUseContext context) {
        Direction.Axis axis = (Direction.Axis)newState.func_177229_b((IProperty)AXIS);
        newState = (BlockState)this.func_176223_P().func_206870_a((IProperty)AXIS, (Comparable)axis);
        if (newState.func_196959_b((IProperty)BlockStateProperties.field_208194_u)) {
            newState = (BlockState)newState.func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
        }
        for (Direction facing : Iterate.directions) {
            if (facing.func_176740_k() == axis) continue;
            BlockPos pos = context.func_195995_a();
            BlockPos offset = pos.func_177972_a(facing);
            newState = this.func_196271_a(newState, facing, context.func_195991_k().func_180495_p(offset), (IWorld)context.func_195991_k(), pos, offset);
        }
        return newState;
    }

    @Override
    public boolean hasShaftTowards(IWorldReader world, BlockPos pos, BlockState state, Direction face) {
        return face.func_176740_k() == state.func_177229_b((IProperty)AXIS);
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.func_177229_b((IProperty)AXIS);
    }

    public static boolean areBlocksConnected(BlockState state, BlockState other, Direction facing) {
        Part part = (Part)((Object)state.func_177229_b(PART));
        Direction.Axis connectionAxis = EncasedBeltBlock.getConnectionAxis(state);
        Direction.Axis otherConnectionAxis = EncasedBeltBlock.getConnectionAxis(other);
        if (otherConnectionAxis != connectionAxis) {
            return false;
        }
        if (facing.func_176740_k() != connectionAxis) {
            return false;
        }
        if (facing.func_176743_c() == Direction.AxisDirection.POSITIVE && (part == Part.MIDDLE || part == Part.START)) {
            return true;
        }
        return facing.func_176743_c() == Direction.AxisDirection.NEGATIVE && (part == Part.MIDDLE || part == Part.END);
    }

    protected static Direction.Axis getConnectionAxis(BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.func_177229_b((IProperty)AXIS);
        boolean connectionAlongFirst = (Boolean)state.func_177229_b((IProperty)CONNECTED_ALONG_FIRST_COORDINATE);
        Direction.Axis connectionAxis = connectionAlongFirst ? (axis == Direction.Axis.X ? Direction.Axis.Y : Direction.Axis.X) : (axis == Direction.Axis.Z ? Direction.Axis.Y : Direction.Axis.Z);
        return connectionAxis;
    }

    public static float getRotationSpeedModifier(KineticTileEntity from, KineticTileEntity to) {
        float fromMod = 1.0f;
        float toMod = 1.0f;
        if (from instanceof AdjustablePulleyTileEntity) {
            fromMod = ((AdjustablePulleyTileEntity)from).getModifier();
        }
        if (to instanceof AdjustablePulleyTileEntity) {
            toMod = ((AdjustablePulleyTileEntity)to).getModifier();
        }
        return fromMod / toMod;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.ENCASED_SHAFT.create();
    }

    public static enum Part implements IStringSerializable
    {
        START,
        MIDDLE,
        END,
        NONE;


        public String func_176610_l() {
            return Lang.asId(this.name());
        }
    }
}

