/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.gearbox;

import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileInstance;
import com.simibubi.create.content.contraptions.base.RotatingData;
import com.simibubi.create.content.contraptions.relays.gearbox.GearboxTileEntity;
import com.simibubi.create.foundation.render.backend.instancing.InstanceData;
import com.simibubi.create.foundation.render.backend.instancing.InstancedModel;
import com.simibubi.create.foundation.render.backend.instancing.InstancedTileRenderer;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.LightType;

public class GearboxInstance
extends KineticTileInstance<GearboxTileEntity> {
    protected final EnumMap<Direction, RotatingData> keys = new EnumMap(Direction.class);
    protected Direction sourceFacing;

    public GearboxInstance(InstancedTileRenderer<?> modelManager, GearboxTileEntity tile) {
        super(modelManager, tile);
        Direction.Axis boxAxis = (Direction.Axis)this.blockState.func_177229_b((IProperty)BlockStateProperties.field_208148_A);
        int blockLight = this.world.func_226658_a_(LightType.BLOCK, this.pos);
        int skyLight = this.world.func_226658_a_(LightType.SKY, this.pos);
        this.updateSourceFacing();
        for (Direction direction : Iterate.directions) {
            Direction.Axis axis = direction.func_176740_k();
            if (boxAxis == axis) continue;
            InstancedModel<RotatingData> shaft = AllBlockPartials.SHAFT_HALF.renderOnDirectionalSouthRotating(modelManager, this.blockState, direction);
            RotatingData key = shaft.createInstance();
            key.setRotationAxis(Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).func_229386_k_()).setRotationalSpeed(this.getSpeed(direction)).setRotationOffset(this.getRotationOffset(axis)).setColor(tile).setPosition(this.getInstancePosition()).setBlockLight(blockLight).setSkyLight(skyLight);
            this.keys.put(direction, key);
        }
    }

    private float getSpeed(Direction direction) {
        float speed = ((GearboxTileEntity)this.tile).getSpeed();
        if (speed != 0.0f && this.sourceFacing != null) {
            if (this.sourceFacing.func_176740_k() == direction.func_176740_k()) {
                speed *= this.sourceFacing == direction ? 1.0f : -1.0f;
            } else if (this.sourceFacing.func_176743_c() == direction.func_176743_c()) {
                speed *= -1.0f;
            }
        }
        return speed;
    }

    protected void updateSourceFacing() {
        if (((GearboxTileEntity)this.tile).hasSource()) {
            BlockPos source = ((GearboxTileEntity)this.tile).source.func_177973_b((Vec3i)this.pos);
            this.sourceFacing = Direction.func_176737_a((float)source.func_177958_n(), (float)source.func_177956_o(), (float)source.func_177952_p());
        } else {
            this.sourceFacing = null;
        }
    }

    @Override
    public void update() {
        this.updateSourceFacing();
        for (Map.Entry<Direction, RotatingData> key : this.keys.entrySet()) {
            Direction direction = key.getKey();
            Direction.Axis axis = direction.func_176740_k();
            this.updateRotation(key.getValue(), axis, this.getSpeed(direction));
        }
    }

    @Override
    public void updateLight() {
        this.relight(this.pos, this.keys.values().stream());
    }

    @Override
    public void remove() {
        this.keys.values().forEach(InstanceData::delete);
        this.keys.clear();
    }
}

