/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.gearbox;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.backend.FastRenderDispatcher;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;

public class GearboxRenderer
extends KineticTileEntityRenderer {
    public GearboxRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (FastRenderDispatcher.available(te.func_145831_w())) {
            return;
        }
        Direction.Axis boxAxis = (Direction.Axis)te.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208148_A);
        BlockPos pos = te.func_174877_v();
        float time = AnimationTickHolder.getRenderTime((IWorld)te.func_145831_w());
        for (Direction direction : Iterate.directions) {
            Direction.Axis axis = direction.func_176740_k();
            if (boxAxis == axis) continue;
            SuperByteBuffer shaft = AllBlockPartials.SHAFT_HALF.renderOnDirectionalSouth(te.func_195044_w(), direction);
            float offset = GearboxRenderer.getRotationOffsetForPosition(te, pos, axis);
            float angle = time * te.getSpeed() * 3.0f / 10.0f % 360.0f;
            if (te.getSpeed() != 0.0f && te.hasSource()) {
                BlockPos source = te.source.func_177973_b((Vec3i)te.func_174877_v());
                Direction sourceFacing = Direction.func_176737_a((float)source.func_177958_n(), (float)source.func_177956_o(), (float)source.func_177952_p());
                if (sourceFacing.func_176740_k() == direction.func_176740_k()) {
                    angle *= sourceFacing == direction ? 1.0f : -1.0f;
                } else if (sourceFacing.func_176743_c() == direction.func_176743_c()) {
                    angle *= -1.0f;
                }
            }
            angle += offset;
            angle = angle / 180.0f * (float)Math.PI;
            GearboxRenderer.kineticRotationTransform(shaft, te, axis, angle, light);
            shaft.renderInto(ms, buffer.getBuffer(RenderType.func_228639_c_()));
        }
    }
}

