/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.symmetry;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.curiosities.symmetry.SymmetryWandItem;
import com.simibubi.create.content.curiosities.symmetry.mirror.EmptyMirror;
import com.simibubi.create.content.curiosities.symmetry.mirror.SymmetryMirror;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ILightReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SymmetryHandler {
    private static int tickCounter = 0;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (event.getWorld().func_201670_d()) {
            return;
        }
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        PlayerInventory inv = player.field_71071_by;
        for (int i = 0; i < PlayerInventory.func_70451_h(); ++i) {
            if (inv.func_70301_a(i).func_190926_b() || inv.func_70301_a(i).func_77973_b() != AllItems.WAND_OF_SYMMETRY.get()) continue;
            SymmetryWandItem.apply(player.field_70170_p, inv.func_70301_a(i), player, event.getPos(), event.getPlacedBlock());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockDestroyed(BlockEvent.BreakEvent event) {
        if (event.getWorld().func_201670_d()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        PlayerInventory inv = player.field_71071_by;
        for (int i = 0; i < PlayerInventory.func_70451_h(); ++i) {
            if (inv.func_70301_a(i).func_190926_b() || !AllItems.WAND_OF_SYMMETRY.isIn(inv.func_70301_a(i))) continue;
            SymmetryWandItem.remove(player.field_70170_p, inv.func_70301_a(i), player, event.getPos());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void render(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        for (int i = 0; i < PlayerInventory.func_70451_h(); ++i) {
            SymmetryMirror mirror;
            ItemStack stackInSlot = player.field_71071_by.func_70301_a(i);
            if (!AllItems.WAND_OF_SYMMETRY.isIn(stackInSlot) || !SymmetryWandItem.isEnabled(stackInSlot) || (mirror = SymmetryWandItem.getMirror(stackInSlot)) instanceof EmptyMirror) continue;
            BlockPos pos = new BlockPos(mirror.getPosition());
            float yShift = 0.0f;
            double speed = 0.0625;
            yShift = MathHelper.func_76126_a((float)((float)((double)AnimationTickHolder.getRenderTime() * speed))) / 5.0f;
            IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            ActiveRenderInfo info = mc.field_71460_t.func_215316_n();
            Vec3d view = info.func_216785_c();
            MatrixStack ms = event.getMatrixStack();
            ms.func_227860_a_();
            ms.func_227861_a_(-view.func_82615_a(), -view.func_82617_b(), -view.func_82616_c());
            ms.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            ms.func_227861_a_(0.0, (double)(yShift + 0.2f), 0.0);
            mirror.applyModelTransform(ms);
            IBakedModel model = mirror.getModel().get();
            IVertexBuilder builder = buffer.getBuffer(RenderType.func_228639_c_());
            mc.func_175602_ab().func_175019_b().renderModel((ILightReader)player.field_70170_p, model, Blocks.field_150350_a.func_176223_P(), pos, ms, builder, true, player.field_70170_p.func_201674_k(), MathHelper.func_180186_a((Vec3i)pos), OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
            buffer.func_228461_a_();
            ms.func_227865_b_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (mc.field_71441_e == null) {
            return;
        }
        if (mc.func_147113_T()) {
            return;
        }
        if (++tickCounter % 10 == 0) {
            for (int i = 0; i < PlayerInventory.func_70451_h(); ++i) {
                SymmetryMirror mirror;
                ItemStack stackInSlot = player.field_71071_by.func_70301_a(i);
                if (stackInSlot == null || !AllItems.WAND_OF_SYMMETRY.isIn(stackInSlot) || !SymmetryWandItem.isEnabled(stackInSlot) || (mirror = SymmetryWandItem.getMirror(stackInSlot)) instanceof EmptyMirror) continue;
                Random r = new Random();
                double offsetX = (r.nextDouble() - 0.5) * 0.3;
                double offsetZ = (r.nextDouble() - 0.5) * 0.3;
                Vec3d pos = mirror.getPosition().func_72441_c(0.5 + offsetX, 0.25, 0.5 + offsetZ);
                Vec3d speed = new Vec3d(0.0, r.nextDouble() * 1.0 / 8.0, 0.0);
                mc.field_71441_e.func_195594_a((IParticleData)ParticleTypes.field_197624_q, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
            }
        }
    }

    public static void drawEffect(BlockPos from, BlockPos to) {
        Vec3d pos;
        double density = 0.8f;
        Vec3d start = new Vec3d((Vec3i)from).func_72441_c(0.5, 0.5, 0.5);
        Vec3d end = new Vec3d((Vec3i)to).func_72441_c(0.5, 0.5, 0.5);
        Vec3d diff = end.func_178788_d(start);
        Vec3d step = diff.func_72432_b().func_186678_a(density);
        int steps = (int)(diff.func_72433_c() / step.func_72433_c());
        Random r = new Random();
        for (int i = 3; i < steps - 1; ++i) {
            pos = start.func_178787_e(step.func_186678_a((double)i));
            Vec3d speed = new Vec3d(0.0, r.nextDouble() * -40.0, 0.0);
            Minecraft.func_71410_x().field_71441_e.func_195594_a((IParticleData)new RedstoneParticleData(1.0f, 1.0f, 1.0f, 1.0f), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
        }
        Vec3d speed = new Vec3d(0.0, r.nextDouble() * 1.0 / 32.0, 0.0);
        pos = start.func_178787_e(step.func_186678_a(2.0));
        Minecraft.func_71410_x().field_71441_e.func_195594_a((IParticleData)ParticleTypes.field_197624_q, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
        speed = new Vec3d(0.0, r.nextDouble() * 1.0 / 32.0, 0.0);
        pos = start.func_178787_e(step.func_186678_a((double)steps));
        Minecraft.func_71410_x().field_71441_e.func_195594_a((IParticleData)ParticleTypes.field_197624_q, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
    }
}

