/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.depot;

import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.depot.DepotItemHandler;
import com.simibubi.create.content.logistics.block.funnel.AbstractFunnelBlock;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.BeltProcessingBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class DepotBehaviour
extends TileEntityBehaviour {
    public static BehaviourType<DepotBehaviour> TYPE = new BehaviourType();
    TransportedItemStack heldItem;
    List<TransportedItemStack> incoming;
    ItemStackHandler processingOutputBuffer;
    DepotItemHandler itemHandler;
    LazyOptional<DepotItemHandler> lazyItemHandler;
    TransportedItemStackHandlerBehaviour transportedHandler;
    Supplier<Integer> maxStackSize = () -> 64;
    Supplier<Boolean> canAcceptItems = () -> true;
    Predicate<Direction> canFunnelsPullFrom = $ -> true;
    boolean allowMerge;

    public DepotBehaviour(final SmartTileEntity te) {
        super(te);
        this.incoming = new ArrayList<TransportedItemStack>();
        this.itemHandler = new DepotItemHandler(this);
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.processingOutputBuffer = new ItemStackHandler(8){

            protected void onContentsChanged(int slot) {
                te.notifyUpdate();
            }
        };
    }

    public void enableMerging() {
        this.allowMerge = true;
    }

    @Override
    public void tick() {
        BeltProcessingBehaviour.ProcessingResult result;
        super.tick();
        World world = this.tileEntity.func_145831_w();
        Iterator<TransportedItemStack> iterator = this.incoming.iterator();
        while (iterator.hasNext()) {
            TransportedItemStack ts = iterator.next();
            if (!this.tick(ts) || world.field_72995_K && !this.tileEntity.isVirtual()) continue;
            if (this.heldItem == null) {
                this.heldItem = ts;
            } else if (!ItemHandlerHelper.canItemStacksStack((ItemStack)this.heldItem.stack, (ItemStack)ts.stack)) {
                Vec3d vec = VecHelper.getCenterOf((Vec3i)this.tileEntity.func_174877_v());
                InventoryHelper.func_180173_a((World)this.tileEntity.func_145831_w(), (double)vec.field_72450_a, (double)(vec.field_72448_b + 0.5), (double)vec.field_72449_c, (ItemStack)ts.stack);
            } else {
                this.heldItem.stack.func_190917_f(ts.stack.func_190916_E());
            }
            iterator.remove();
            this.tileEntity.notifyUpdate();
        }
        if (this.heldItem == null) {
            return;
        }
        if (!this.tick(this.heldItem)) {
            return;
        }
        BlockPos pos = this.tileEntity.func_174877_v();
        if (world.field_72995_K) {
            return;
        }
        if (this.handleBeltFunnelOutput()) {
            return;
        }
        BeltProcessingBehaviour processingBehaviour = TileEntityBehaviour.get((IBlockReader)world, pos.func_177981_b(2), BeltProcessingBehaviour.TYPE);
        if (processingBehaviour == null) {
            return;
        }
        if (!this.heldItem.locked && BeltProcessingBehaviour.isBlocked((IBlockReader)world, pos)) {
            return;
        }
        ItemStack previousItem = this.heldItem.stack;
        boolean wasLocked = this.heldItem.locked;
        BeltProcessingBehaviour.ProcessingResult processingResult = result = wasLocked ? processingBehaviour.handleHeldItem(this.heldItem, this.transportedHandler) : processingBehaviour.handleReceivedItem(this.heldItem, this.transportedHandler);
        if (result == BeltProcessingBehaviour.ProcessingResult.REMOVE) {
            this.heldItem = null;
            this.tileEntity.sendData();
            return;
        }
        boolean bl = this.heldItem.locked = result == BeltProcessingBehaviour.ProcessingResult.HOLD;
        if (this.heldItem.locked != wasLocked || !previousItem.equals(this.heldItem.stack, false)) {
            this.tileEntity.sendData();
        }
    }

    protected boolean tick(TransportedItemStack heldItem) {
        heldItem.prevBeltPosition = heldItem.beltPosition;
        heldItem.prevSideOffset = heldItem.sideOffset;
        float diff = 0.5f - heldItem.beltPosition;
        if (diff > 0.001953125f) {
            if (diff > 0.03125f && !BeltHelper.isItemUpright(heldItem.stack)) {
                ++heldItem.angle;
            }
            heldItem.beltPosition += diff / 4.0f;
        }
        return diff < 0.0625f;
    }

    private boolean handleBeltFunnelOutput() {
        BlockState funnel = this.getWorld().func_180495_p(this.getPos().func_177984_a());
        Direction funnelFacing = AbstractFunnelBlock.getFunnelFacing(funnel);
        if (funnelFacing == null || !this.canFunnelsPullFrom.test(funnelFacing.func_176734_d())) {
            return false;
        }
        for (int slot = 0; slot < this.processingOutputBuffer.getSlots(); ++slot) {
            ItemStack previousItem = this.processingOutputBuffer.getStackInSlot(slot);
            if (previousItem.func_190926_b()) continue;
            ItemStack afterInsert = this.tileEntity.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(previousItem, null, false);
            if (afterInsert == null) {
                return false;
            }
            if (previousItem.func_190916_E() == afterInsert.func_190916_E()) continue;
            this.processingOutputBuffer.setStackInSlot(slot, afterInsert);
            this.tileEntity.notifyUpdate();
            return true;
        }
        ItemStack previousItem = this.heldItem.stack;
        ItemStack afterInsert = this.tileEntity.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(previousItem, null, false);
        if (afterInsert == null) {
            return false;
        }
        if (previousItem.func_190916_E() != afterInsert.func_190916_E()) {
            if (afterInsert.func_190926_b()) {
                this.heldItem = null;
            } else {
                this.heldItem.stack = afterInsert;
            }
            this.tileEntity.notifyUpdate();
            return true;
        }
        return false;
    }

    @Override
    public void remove() {
        if (this.lazyItemHandler != null) {
            this.lazyItemHandler.invalidate();
        }
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        if (this.heldItem != null) {
            compound.func_218657_a("HeldItem", (INBT)this.heldItem.serializeNBT());
        }
        compound.func_218657_a("OutputBuffer", (INBT)this.processingOutputBuffer.serializeNBT());
        if (this.canMergeItems() && !this.incoming.isEmpty()) {
            compound.func_218657_a("Incoming", (INBT)NBTHelper.writeCompoundList(this.incoming, TransportedItemStack::serializeNBT));
        }
    }

    @Override
    public void read(CompoundNBT compound, boolean clientPacket) {
        this.heldItem = null;
        if (compound.func_74764_b("HeldItem")) {
            this.heldItem = TransportedItemStack.read(compound.func_74775_l("HeldItem"));
        }
        this.processingOutputBuffer.deserializeNBT(compound.func_74775_l("OutputBuffer"));
        if (this.canMergeItems()) {
            ListNBT list = compound.func_150295_c("Incoming", 10);
            this.incoming = NBTHelper.readCompoundList(list, TransportedItemStack::read);
        }
    }

    public void addSubBehaviours(List<TileEntityBehaviour> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this.tileEntity).allowingBeltFunnels().setInsertionHandler(this::tryInsertingFromSide));
        this.transportedHandler = new TransportedItemStackHandlerBehaviour(this.tileEntity, this::applyToAllItems).withStackPlacement(this::getWorldPositionOf);
        behaviours.add(this.transportedHandler);
    }

    public ItemStack getHeldItemStack() {
        return this.heldItem == null ? ItemStack.field_190927_a : this.heldItem.stack;
    }

    public boolean canMergeItems() {
        return this.allowMerge;
    }

    public int getPresentStackSize() {
        int cumulativeStackSize = 0;
        cumulativeStackSize += this.getHeldItemStack().func_190916_E();
        for (int slot = 0; slot < this.processingOutputBuffer.getSlots(); ++slot) {
            cumulativeStackSize += this.processingOutputBuffer.getStackInSlot(slot).func_190916_E();
        }
        return cumulativeStackSize;
    }

    public int getRemainingSpace() {
        int cumulativeStackSize = this.getPresentStackSize();
        for (TransportedItemStack transportedItemStack : this.incoming) {
            cumulativeStackSize += transportedItemStack.stack.func_190916_E();
        }
        int fromGetter = this.maxStackSize.get();
        return (fromGetter == 0 ? 64 : fromGetter) - cumulativeStackSize;
    }

    public ItemStack insert(TransportedItemStack heldItem, boolean simulate) {
        if (!this.canAcceptItems.get().booleanValue()) {
            return heldItem.stack;
        }
        if (this.canMergeItems()) {
            int remainingSpace = this.getRemainingSpace();
            ItemStack inserted = heldItem.stack;
            if (remainingSpace <= 0) {
                return inserted;
            }
            if (this.heldItem != null && !ItemHandlerHelper.canItemStacksStack((ItemStack)this.heldItem.stack, (ItemStack)inserted)) {
                return inserted;
            }
            ItemStack returned = ItemStack.field_190927_a;
            if (remainingSpace < inserted.func_190916_E()) {
                returned = ItemHandlerHelper.copyStackWithSize((ItemStack)heldItem.stack, (int)(inserted.func_190916_E() - remainingSpace));
                if (!simulate) {
                    TransportedItemStack copy = heldItem.copy();
                    copy.stack.func_190920_e(remainingSpace);
                    if (this.heldItem != null) {
                        this.incoming.add(copy);
                    } else {
                        this.heldItem = copy;
                    }
                }
            } else if (!simulate) {
                if (this.heldItem != null) {
                    this.incoming.add(heldItem);
                } else {
                    this.heldItem = heldItem;
                }
            }
            return returned;
        }
        if (!simulate) {
            this.heldItem = heldItem;
        }
        return ItemStack.field_190927_a;
    }

    public void setHeldItem(TransportedItemStack heldItem) {
        this.heldItem = heldItem;
    }

    public void removeHeldItem() {
        this.heldItem = null;
    }

    public void setCenteredHeldItem(TransportedItemStack heldItem) {
        this.heldItem = heldItem;
        this.heldItem.beltPosition = 0.5f;
        this.heldItem.prevBeltPosition = 0.5f;
    }

    public <T> LazyOptional<T> getItemCapability(Capability<T> cap, Direction side) {
        return this.lazyItemHandler.cast();
    }

    private ItemStack tryInsertingFromSide(TransportedItemStack transportedStack, Direction side, boolean simulate) {
        ItemStack inserted = transportedStack.stack;
        if (!this.getHeldItemStack().func_190926_b() && !this.canMergeItems()) {
            return inserted;
        }
        if (!this.isOutputEmpty() && !this.canMergeItems()) {
            return inserted;
        }
        if (!this.canAcceptItems.get().booleanValue()) {
            return inserted;
        }
        int size = transportedStack.stack.func_190916_E();
        transportedStack = transportedStack.copy();
        transportedStack.beltPosition = side.func_176740_k().func_200128_b() ? 0.5f : 0.0f;
        transportedStack.insertedFrom = side;
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        ItemStack remainder = this.insert(transportedStack, simulate);
        if (remainder.func_190916_E() != size) {
            this.tileEntity.notifyUpdate();
        }
        return remainder;
    }

    private void applyToAllItems(float maxDistanceFromCentre, Function<TransportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult> processFunction) {
        if (this.heldItem == null) {
            return;
        }
        if (0.5f - this.heldItem.beltPosition > maxDistanceFromCentre) {
            return;
        }
        boolean dirty = false;
        TransportedItemStack transportedItemStack = this.heldItem;
        ItemStack stackBefore = transportedItemStack.stack.func_77946_l();
        TransportedItemStackHandlerBehaviour.TransportedResult result = processFunction.apply(transportedItemStack);
        if (result == null || result.didntChangeFrom(stackBefore)) {
            return;
        }
        dirty = true;
        this.heldItem = null;
        if (result.hasHeldOutput()) {
            this.setCenteredHeldItem(result.getHeldOutput());
        }
        for (TransportedItemStack added : result.getOutputs()) {
            if (this.getHeldItemStack().func_190926_b()) {
                this.setCenteredHeldItem(added);
                continue;
            }
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)this.processingOutputBuffer, (ItemStack)added.stack, (boolean)false);
            Vec3d vec = VecHelper.getCenterOf((Vec3i)this.tileEntity.func_174877_v());
            InventoryHelper.func_180173_a((World)this.tileEntity.func_145831_w(), (double)vec.field_72450_a, (double)(vec.field_72448_b + 0.5), (double)vec.field_72449_c, (ItemStack)remainder);
        }
        if (dirty) {
            this.tileEntity.notifyUpdate();
        }
    }

    public boolean isEmpty() {
        return this.heldItem == null && this.isOutputEmpty();
    }

    public boolean isOutputEmpty() {
        for (int i = 0; i < this.processingOutputBuffer.getSlots(); ++i) {
            if (this.processingOutputBuffer.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private Vec3d getWorldPositionOf(TransportedItemStack transported) {
        Vec3d offsetVec = new Vec3d(0.5, 0.875, 0.5);
        return offsetVec.func_178787_e(new Vec3d((Vec3i)this.tileEntity.func_174877_v()));
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }
}

