/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.funnel;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.logistics.block.funnel.FunnelTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractFunnelBlock
extends Block
implements ITE<FunnelTileEntity>,
IWrenchable {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    protected AbstractFunnelBlock(Block.Properties p_i48377_1_) {
        super(p_i48377_1_);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder.func_206894_a(new IProperty[]{POWERED}));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        BlockHelper.addReducedDestroyEffects(state, world, pos, manager);
        return true;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean previouslyPowered;
        if (worldIn.field_72995_K) {
            return;
        }
        InvManipulationBehaviour behaviour = TileEntityBehaviour.get((IBlockReader)worldIn, pos, InvManipulationBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.onNeighborChanged(fromPos);
        }
        if ((previouslyPowered = ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) != worldIn.func_175640_z(pos)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)POWERED), 2);
        }
    }

    public static ItemStack tryInsert(World worldIn, BlockPos pos, ItemStack toInsert, boolean simulate) {
        TileEntity tileEntity;
        FilteringBehaviour filter = TileEntityBehaviour.get((IBlockReader)worldIn, pos, FilteringBehaviour.TYPE);
        InvManipulationBehaviour inserter = TileEntityBehaviour.get((IBlockReader)worldIn, pos, InvManipulationBehaviour.TYPE);
        if (inserter == null) {
            return toInsert;
        }
        if (filter != null && !filter.test(toInsert)) {
            return toInsert;
        }
        if (simulate) {
            inserter.simulate();
        }
        ItemStack insert = inserter.insert(toInsert);
        if (!simulate && insert.func_190916_E() != toInsert.func_190916_E() && (tileEntity = worldIn.func_175625_s(pos)) instanceof FunnelTileEntity) {
            FunnelTileEntity funnelTileEntity = (FunnelTileEntity)tileEntity;
            funnelTileEntity.onTransfer(toInsert);
            if (funnelTileEntity.hasFlap()) {
                funnelTileEntity.flap(true);
            }
        }
        return insert;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.FUNNEL.create();
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Block block = world.func_180495_p(pos.func_177972_a(AbstractFunnelBlock.getFunnelFacing(state).func_176734_d())).func_177230_c();
        return !(block instanceof AbstractFunnelBlock);
    }

    @Nullable
    public static boolean isFunnel(BlockState state) {
        return state.func_177230_c() instanceof AbstractFunnelBlock;
    }

    @Nullable
    public static Direction getFunnelFacing(BlockState state) {
        if (!(state.func_177230_c() instanceof AbstractFunnelBlock)) {
            return null;
        }
        return ((AbstractFunnelBlock)state.func_177230_c()).getFacing(state);
    }

    protected abstract Direction getFacing(BlockState var1);

    public void func_196243_a(BlockState p_196243_1_, World p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (p_196243_1_.hasTileEntity() && (p_196243_1_.func_177230_c() != p_196243_4_.func_177230_c() && !AbstractFunnelBlock.isFunnel(p_196243_4_) || !p_196243_4_.hasTileEntity())) {
            TileEntityBehaviour.destroy((IBlockReader)p_196243_2_, p_196243_3_, FilteringBehaviour.TYPE);
            p_196243_2_.func_175713_t(p_196243_3_);
        }
    }

    @Override
    public Class<FunnelTileEntity> getTileEntityClass() {
        return FunnelTileEntity.class;
    }
}

