/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.funnel;

import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticRenderMaterials;
import com.simibubi.create.content.logistics.block.FlapData;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelTileEntity;
import com.simibubi.create.foundation.render.backend.instancing.IDynamicInstance;
import com.simibubi.create.foundation.render.backend.instancing.InstanceData;
import com.simibubi.create.foundation.render.backend.instancing.InstancedModel;
import com.simibubi.create.foundation.render.backend.instancing.InstancedTileRenderer;
import com.simibubi.create.foundation.render.backend.instancing.TileEntityInstance;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import java.util.ArrayList;
import net.minecraft.util.Direction;
import net.minecraft.world.LightType;

public class FunnelInstance
extends TileEntityInstance<FunnelTileEntity>
implements IDynamicInstance {
    private final ArrayList<FlapData> flaps = new ArrayList(4);

    public FunnelInstance(InstancedTileRenderer<?> modelManager, FunnelTileEntity tile) {
        super(modelManager, tile);
        if (!tile.hasFlap()) {
            return;
        }
        AllBlockPartials flapPartial = this.blockState.func_177230_c() instanceof FunnelBlock ? AllBlockPartials.FUNNEL_FLAP : AllBlockPartials.BELT_FUNNEL_FLAP;
        InstancedModel<FlapData> model = modelManager.getMaterial(KineticRenderMaterials.FLAPS).getModel(flapPartial, this.blockState);
        int blockLight = this.world.func_226658_a_(LightType.BLOCK, this.pos);
        int skyLight = this.world.func_226658_a_(LightType.SKY, this.pos);
        Direction direction = FunnelBlock.getFunnelFacing(this.blockState);
        float flapness = tile.flap.get(AnimationTickHolder.getPartialTicks());
        float horizontalAngle = direction.func_176734_d().func_185119_l();
        for (int segment = 0; segment <= 3; ++segment) {
            float intensity = segment == 3 ? 1.5f : (float)(segment + 1);
            float segmentOffset = -0.1875f * (float)segment;
            FlapData key = model.createInstance();
            key.setPosition(this.pos).setSegmentOffset(segmentOffset, 0.0f, -tile.getFlapOffset()).setBlockLight(blockLight).setSkyLight(skyLight).setHorizontalAngle(horizontalAngle).setFlapness(flapness).setFlapScale(-1.0f).setPivotVoxelSpace(0.0f, 10.0f, 9.5f).setIntensity(intensity);
            this.flaps.add(key);
        }
    }

    @Override
    public void beginFrame() {
        if (this.flaps == null) {
            return;
        }
        float flapness = ((FunnelTileEntity)this.tile).flap.get(AnimationTickHolder.getPartialTicks());
        for (FlapData flap : this.flaps) {
            flap.setFlapness(flapness);
        }
    }

    @Override
    public void updateLight() {
        if (this.flaps != null) {
            this.relight(this.pos, this.flaps.stream());
        }
    }

    @Override
    public void remove() {
        if (this.flaps == null) {
            return;
        }
        this.flaps.forEach(InstanceData::delete);
    }
}

