/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.mechanicalArm;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmPlacementPacket;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmTileEntity;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ArmInteractionPointHandler {
    static List<ArmInteractionPoint> currentSelection = new ArrayList<ArmInteractionPoint>();
    static ItemStack currentItem;
    static long lastBlockPos;

    @SubscribeEvent
    public static void rightClickingBlocksSelectsThem(PlayerInteractEvent.RightClickBlock event) {
        if (currentItem == null) {
            return;
        }
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        if (!world.field_72995_K) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (player != null && player.func_175149_v()) {
            return;
        }
        ArmInteractionPoint selected = ArmInteractionPointHandler.getSelected(pos);
        if (selected == null) {
            ArmInteractionPoint point = ArmInteractionPoint.createAt((IBlockReader)world, pos);
            if (point == null) {
                return;
            }
            selected = point;
            ArmInteractionPointHandler.put(point);
        }
        selected.cycleMode();
        if (player != null) {
            String key = selected.mode == ArmInteractionPoint.Mode.DEPOSIT ? "mechanical_arm.deposit_to" : "mechanical_arm.extract_from";
            TextFormatting colour = selected.mode == ArmInteractionPoint.Mode.DEPOSIT ? TextFormatting.GOLD : TextFormatting.AQUA;
            String translatedBlock = new TranslationTextComponent(selected.state.func_177230_c().func_149739_a(), new Object[0]).func_150254_d();
            player.func_146105_b((ITextComponent)new StringTextComponent(colour + Lang.translate(key, TextFormatting.WHITE + translatedBlock + colour)), true);
        }
        event.setCanceled(true);
        event.setCancellationResult(ActionResultType.SUCCESS);
    }

    @SubscribeEvent
    public static void leftClickingBlocksDeselectsThem(PlayerInteractEvent.LeftClickBlock event) {
        if (currentItem == null) {
            return;
        }
        if (!event.getWorld().field_72995_K) {
            return;
        }
        BlockPos pos = event.getPos();
        if (ArmInteractionPointHandler.remove(pos) != null) {
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
        }
    }

    public static void flushSettings(BlockPos pos) {
        if (currentItem == null) {
            return;
        }
        int removed = 0;
        Iterator<ArmInteractionPoint> iterator = currentSelection.iterator();
        while (iterator.hasNext()) {
            ArmInteractionPoint point = iterator.next();
            if (point.pos.func_218141_a((Vec3i)pos, (double)ArmTileEntity.getRange())) continue;
            iterator.remove();
            ++removed;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (removed > 0) {
            player.func_146105_b(Lang.createTranslationTextComponent("mechanical_arm.points_outside_range", removed).func_211708_a(TextFormatting.RED), true);
        } else {
            int inputs = 0;
            int outputs = 0;
            for (ArmInteractionPoint armInteractionPoint : currentSelection) {
                if (armInteractionPoint.mode == ArmInteractionPoint.Mode.DEPOSIT) {
                    ++outputs;
                    continue;
                }
                ++inputs;
            }
            if (inputs + outputs > 0) {
                player.func_146105_b(Lang.createTranslationTextComponent("mechanical_arm.summary", inputs, outputs).func_211708_a(TextFormatting.WHITE), true);
            }
        }
        AllPackets.channel.sendToServer((Object)new ArmPlacementPacket(currentSelection, pos));
        currentSelection.clear();
        currentItem = null;
    }

    public static void tick() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack heldItemMainhand = player.func_184614_ca();
        if (!AllBlocks.MECHANICAL_ARM.isIn(heldItemMainhand)) {
            currentItem = null;
        } else {
            if (heldItemMainhand != currentItem) {
                currentSelection.clear();
                currentItem = heldItemMainhand;
            }
            ArmInteractionPointHandler.drawOutlines(currentSelection);
        }
        ArmInteractionPointHandler.checkForWrench(heldItemMainhand);
    }

    private static void checkForWrench(ItemStack heldItem) {
        if (!AllItems.WRENCH.isIn(heldItem)) {
            return;
        }
        RayTraceResult objectMouseOver = Minecraft.func_71410_x().field_71476_x;
        if (!(objectMouseOver instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult result = (BlockRayTraceResult)objectMouseOver;
        BlockPos pos = result.func_216350_a();
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
        if (!(te instanceof ArmTileEntity)) {
            lastBlockPos = -1L;
            currentSelection.clear();
            return;
        }
        if (lastBlockPos == -1L || lastBlockPos != pos.func_218275_a()) {
            currentSelection.clear();
            ArmTileEntity arm = (ArmTileEntity)te;
            arm.inputs.forEach(ArmInteractionPointHandler::put);
            arm.outputs.forEach(ArmInteractionPointHandler::put);
            lastBlockPos = pos.func_218275_a();
        }
        if (lastBlockPos != -1L) {
            ArmInteractionPointHandler.drawOutlines(currentSelection);
        }
    }

    private static void drawOutlines(Collection<ArmInteractionPoint> selection) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        Iterator<ArmInteractionPoint> iterator = selection.iterator();
        while (iterator.hasNext()) {
            BlockState state;
            BlockPos pos;
            ArmInteractionPoint point = iterator.next();
            if (!point.isValid((IBlockReader)world, pos = point.pos, state = world.func_180495_p(pos))) {
                iterator.remove();
                continue;
            }
            VoxelShape shape = state.func_196954_c((IBlockReader)world, pos);
            if (shape.func_197766_b()) continue;
            int color = point.mode == ArmInteractionPoint.Mode.DEPOSIT ? 16763764 : 5212811;
            CreateClient.outliner.showAABB(point, shape.func_197752_a().func_186670_a(pos)).colored(color).lineWidth(0.0625f);
        }
    }

    private static void put(ArmInteractionPoint point) {
        currentSelection.add(point);
    }

    private static ArmInteractionPoint remove(BlockPos pos) {
        ArmInteractionPoint result = ArmInteractionPointHandler.getSelected(pos);
        if (result != null) {
            currentSelection.remove(result);
        }
        return result;
    }

    private static ArmInteractionPoint getSelected(BlockPos pos) {
        for (ArmInteractionPoint point : currentSelection) {
            if (!point.pos.equals((Object)pos)) continue;
            return point;
        }
        return null;
    }

    static {
        lastBlockPos = -1L;
    }
}

