/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Pair;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.world.server.ServerWorld;

public class NixieTubeTileEntity
extends SmartTileEntity {
    Optional<Pair<ITextComponent, Integer>> customText = Optional.empty();
    JsonElement rawCustomText;
    Couple<String> renderText;
    int redstoneStrength = 0;

    public NixieTubeTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.customText.isPresent() && this.field_145850_b instanceof ServerWorld) {
            Pair<ITextComponent, Integer> textSection = this.customText.get();
            textSection.setFirst(this.updateDynamicTextComponents(ITextComponent.Serializer.func_197672_a((JsonElement)this.rawCustomText)));
            Couple<String> currentText = this.getVisibleText();
            if (this.renderText != null && this.renderText.equals(currentText)) {
                return;
            }
            this.renderText = currentText;
            this.sendData();
        }
    }

    public void clearCustomText() {
        if (!this.customText.isPresent()) {
            return;
        }
        this.displayRedstoneStrength(0);
    }

    public void displayCustomNameOf(ItemStack stack, int nixiePositionInRow) {
        CompoundNBT compoundnbt = stack.func_179543_a("display");
        if (compoundnbt != null && compoundnbt.func_150297_b("Name", 8)) {
            JsonElement fromJson = this.getJsonFromString(compoundnbt.func_74779_i("Name"));
            ITextComponent displayed = ITextComponent.Serializer.func_197672_a((JsonElement)fromJson);
            if (this.field_145850_b instanceof ServerWorld) {
                displayed = this.updateDynamicTextComponents(displayed);
            }
            this.customText = Optional.of(Pair.of(displayed, nixiePositionInRow));
            this.rawCustomText = fromJson;
            this.notifyUpdate();
        }
    }

    public void displayRedstoneStrength(int signalStrength) {
        this.customText = Optional.empty();
        this.redstoneStrength = signalStrength;
        this.notifyUpdate();
    }

    public boolean reactsToRedstone() {
        return !this.customText.isPresent();
    }

    public Couple<String> getVisibleText() {
        if (!this.customText.isPresent()) {
            return Couple.create(this.redstoneStrength < 10 ? "0" : "1", this.redstoneStrength % 10 + "");
        }
        String fullText = this.createStringFromComponentText(this.customText.get().getFirst());
        int index = this.customText.get().getSecond() * 2;
        return Couple.create(this.charOrEmpty(fullText, index), this.charOrEmpty(fullText, index + 1));
    }

    @Override
    protected void read(CompoundNBT nbt, boolean clientPacket) {
        this.customText = Optional.empty();
        this.redstoneStrength = nbt.func_74762_e("RedstoneStrength");
        if (nbt.func_74764_b("CustomText")) {
            ITextComponent displayed = ITextComponent.Serializer.func_150699_a((String)nbt.func_74779_i("CustomText"));
            this.rawCustomText = this.getJsonFromString(nbt.func_74779_i("RawCustomText"));
            this.customText = Optional.of(Pair.of(displayed, nbt.func_74762_e("CustomTextIndex")));
        }
        super.read(nbt, clientPacket);
    }

    @Override
    protected void write(CompoundNBT nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        nbt.func_74768_a("RedstoneStrength", this.redstoneStrength);
        if (this.customText.isPresent()) {
            nbt.func_74778_a("RawCustomText", this.rawCustomText.toString());
            nbt.func_74778_a("CustomText", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customText.get().getFirst()));
            nbt.func_74768_a("CustomTextIndex", this.customText.get().getSecond().intValue());
        }
    }

    private JsonElement getJsonFromString(String string) {
        return new JsonParser().parse(string);
    }

    protected ITextComponent updateDynamicTextComponents(ITextComponent customText) {
        try {
            return TextComponentUtils.func_197680_a((CommandSource)this.getCommandSource(null), (ITextComponent)customText, (Entity)null, (int)0);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return customText;
        }
    }

    protected CommandSource getCommandSource(@Nullable ServerPlayerEntity p_195539_1_) {
        String s = p_195539_1_ == null ? "Sign" : p_195539_1_.func_200200_C_().getString();
        StringTextComponent itextcomponent = p_195539_1_ == null ? new StringTextComponent("Sign") : p_195539_1_.func_145748_c_();
        return new CommandSource(ICommandSource.field_213139_a_, new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5), Vec2f.field_189974_a, (ServerWorld)this.field_145850_b, 2, s, (ITextComponent)itextcomponent, this.field_145850_b.func_73046_m(), (Entity)p_195539_1_);
    }

    protected String createStringFromComponentText(ITextComponent iTextComponent) {
        StringBuilder stringbuilder = new StringBuilder();
        Iterator iterator = iTextComponent.func_212640_c().iterator();
        while (iterator.hasNext()) {
            stringbuilder.append(((ITextComponent)iterator.next()).func_150261_e());
        }
        return stringbuilder.toString();
    }

    private String charOrEmpty(String string, int index) {
        return string.length() <= index ? " " : string.substring(index, index + 1);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }
}

