/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.block.redstone.StockpileSwitchTileEntity;
import com.simibubi.create.content.logistics.packet.ConfigureStockswitchPacket;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.gui.widgets.ScrollInput;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class StockpileSwitchScreen
extends AbstractSimiScreen {
    private ScrollInput offBelow;
    private ScrollInput onAbove;
    private IconButton confirmButton;
    private IconButton flipSignals;
    private final String title = Lang.translate("gui.stockpile_switch.title", new Object[0]);
    private final String invertSignal = Lang.translate("gui.stockpile_switch.invert_signal", new Object[0]);
    private final ItemStack renderedItem = new ItemStack((IItemProvider)AllBlocks.STOCKPILE_SWITCH.get());
    private int lastModification;
    private StockpileSwitchTileEntity te;
    private LerpedFloat cursor;
    private LerpedFloat cursorLane;

    public StockpileSwitchScreen(StockpileSwitchTileEntity te) {
        this.te = te;
        this.lastModification = -1;
    }

    protected void init() {
        AllGuiTextures background = AllGuiTextures.STOCKSWITCH;
        this.setWindowSize(background.width + 50, background.height);
        super.init();
        this.widgets.clear();
        this.cursor = LerpedFloat.linear().startWithValue(this.te.getLevelForDisplay());
        this.cursorLane = LerpedFloat.linear().startWithValue(this.te.getState() ? 1.0 : 0.0);
        this.offBelow = new ScrollInput(this.guiLeft + 36, this.guiTop + 40, 102, 18).withRange(0, 100).titled("").calling(state -> {
            this.lastModification = 0;
            this.offBelow.titled(Lang.translate("gui.stockpile_switch.move_to_upper_at", state));
            if (this.onAbove.getState() <= state) {
                this.onAbove.setState(state + 1);
                this.onAbove.onChanged();
            }
        }).setState((int)(this.te.offWhenBelow * 100.0f));
        this.onAbove = new ScrollInput(this.guiLeft + 36, this.guiTop + 18, 102, 18).withRange(1, 101).titled("").calling(state -> {
            this.lastModification = 0;
            this.onAbove.titled(Lang.translate("gui.stockpile_switch.move_to_lower_at", state));
            if (this.offBelow.getState() >= state) {
                this.offBelow.setState(state - 1);
                this.offBelow.onChanged();
            }
        }).setState((int)(this.te.onWhenAbove * 100.0f));
        this.onAbove.onChanged();
        this.offBelow.onChanged();
        this.widgets.add(this.onAbove);
        this.widgets.add(this.offBelow);
        this.confirmButton = new IconButton(this.guiLeft + background.width - 33, this.guiTop + background.height - 24, AllIcons.I_CONFIRM);
        this.widgets.add(this.confirmButton);
        this.flipSignals = new IconButton(this.guiLeft + 14, this.guiTop + 40, AllIcons.I_FLIP);
        this.flipSignals.setToolTip(this.invertSignal);
        this.widgets.add(this.flipSignals);
    }

    @Override
    protected void renderWindow(int mouseX, int mouseY, float partialTicks) {
        AllGuiTextures.STOCKSWITCH.draw((AbstractGui)this, this.guiLeft, this.guiTop);
        AllGuiTextures.STOCKSWITCH_POWERED_LANE.draw((AbstractGui)this, this.guiLeft + 36, this.guiTop + (this.te.isInverted() ? 18 : 40));
        AllGuiTextures.STOCKSWITCH_UNPOWERED_LANE.draw((AbstractGui)this, this.guiLeft + 36, this.guiTop + (this.te.isInverted() ? 40 : 18));
        this.font.func_175063_a(this.title, (float)(this.guiLeft - 3 + (AllGuiTextures.STOCKSWITCH.width - this.font.func_78256_a(this.title)) / 2), (float)(this.guiTop + 3), 0xFFFFFF);
        AllGuiTextures sprite = AllGuiTextures.STOCKSWITCH_INTERVAL;
        float lowerBound = this.offBelow.getState();
        float upperBound = this.onAbove.getState();
        sprite.bind();
        this.blit((int)((float)this.guiLeft + upperBound) + 37, this.guiTop + 18, (int)((float)sprite.startX + upperBound), sprite.startY, (int)((float)sprite.width - upperBound), sprite.height);
        this.blit(this.guiLeft + 37, this.guiTop + 40, sprite.startX, sprite.startY, (int)lowerBound, sprite.height);
        AllGuiTextures.STOCKSWITCH_ARROW_UP.draw((AbstractGui)this, (int)((float)this.guiLeft + lowerBound + 36.0f) - 2, this.guiTop + 35);
        AllGuiTextures.STOCKSWITCH_ARROW_DOWN.draw((AbstractGui)this, (int)((float)this.guiLeft + upperBound + 36.0f) - 3, this.guiTop + 17);
        if (this.te.currentLevel != -1.0f) {
            AllGuiTextures cursor = AllGuiTextures.STOCKSWITCH_CURSOR;
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)Math.min(99.0f, this.cursor.getValue(partialTicks) * (float)sprite.width), (float)(this.cursorLane.getValue(partialTicks) * 22.0f), (float)0.0f);
            cursor.draw((AbstractGui)this, this.guiLeft + 34, this.guiTop + 19);
            RenderSystem.popMatrix();
        }
        RenderSystem.pushMatrix();
        GuiGameElement.of(this.renderedItem).at(this.guiLeft + AllGuiTextures.STOCKSWITCH.width + 15, this.guiTop + 20).scale(5.0).render();
        RenderSystem.popMatrix();
    }

    public void tick() {
        super.tick();
        this.cursor.chase(this.te.getLevelForDisplay(), 0.25, LerpedFloat.Chaser.EXP);
        this.cursor.tickChaser();
        this.cursorLane.chase(this.te.getState() ? 1.0 : 0.0, 0.25, LerpedFloat.Chaser.EXP);
        this.cursorLane.tickChaser();
        if (this.lastModification >= 0) {
            ++this.lastModification;
        }
        if (this.lastModification >= 20) {
            this.lastModification = -1;
            this.send(this.te.isInverted());
        }
    }

    public void removed() {
        this.send(this.te.isInverted());
    }

    protected void send(boolean invert) {
        AllPackets.channel.sendToServer((Object)new ConfigureStockswitchPacket(this.te.func_174877_v(), (float)this.offBelow.getState() / 100.0f, (float)this.onAbove.getState() / 100.0f, invert));
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        if (this.flipSignals.isHovered()) {
            this.send(!this.te.isInverted());
        }
        if (this.confirmButton.isHovered()) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            return true;
        }
        return super.mouseClicked(x, y, button);
    }
}

