/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.simibubi.create.content.logistics.block.redstone.FilteredDetectorFilterSlot;
import com.simibubi.create.content.logistics.block.redstone.StockpileSwitchBlock;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.InvManipulationBehaviour;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.items.IItemHandler;

public class StockpileSwitchTileEntity
extends SmartTileEntity {
    public float onWhenAbove = 0.75f;
    public float offWhenBelow = 0.25f;
    public float currentLevel = -1.0f;
    private boolean state = false;
    private boolean inverted = false;
    private FilteringBehaviour filtering;
    private InvManipulationBehaviour observedInventory;

    public StockpileSwitchTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
        this.setLazyTickRate(10);
    }

    @Override
    protected void read(CompoundNBT compound, boolean clientPacket) {
        this.onWhenAbove = compound.func_74760_g("OnAbove");
        this.offWhenBelow = compound.func_74760_g("OffBelow");
        this.currentLevel = compound.func_74760_g("Current");
        this.state = compound.func_74767_n("Powered");
        this.inverted = compound.func_74767_n("Inverted");
        super.read(compound, clientPacket);
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_74776_a("OnAbove", this.onWhenAbove);
        compound.func_74776_a("OffBelow", this.offWhenBelow);
        compound.func_74776_a("Current", this.currentLevel);
        compound.func_74757_a("Powered", this.state);
        compound.func_74757_a("Inverted", this.inverted);
        super.write(compound, clientPacket);
    }

    public float getLevel() {
        return this.currentLevel;
    }

    public void updateCurrentLevel() {
        boolean changed = false;
        this.observedInventory.findNewCapability();
        if (!this.observedInventory.hasInventory()) {
            if (this.currentLevel == -1.0f) {
                return;
            }
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((IProperty)StockpileSwitchBlock.INDICATOR, (Comparable)Integer.valueOf(0)), 3);
            this.currentLevel = -1.0f;
            this.state = false;
            this.field_145850_b.func_195592_c(this.field_174879_c, this.func_195044_w().func_177230_c());
            this.sendData();
            return;
        }
        float occupied = 0.0f;
        float totalSpace = 0.0f;
        IItemHandler inv = this.observedInventory.getInventory();
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stackInSlot = inv.getStackInSlot(slot);
            int space = Math.min(stackInSlot.func_77976_d(), inv.getSlotLimit(slot));
            int count = stackInSlot.func_190916_E();
            if (space == 0) continue;
            totalSpace += 1.0f;
            if (!this.filtering.test(stackInSlot)) continue;
            occupied += (float)count * (1.0f / (float)space);
        }
        float level = occupied / totalSpace;
        if (this.currentLevel != level) {
            changed = true;
        }
        this.currentLevel = level;
        this.currentLevel = MathHelper.func_76131_a((float)this.currentLevel, (float)0.0f, (float)1.0f);
        boolean previouslyPowered = this.state;
        if (this.state && this.currentLevel <= this.offWhenBelow) {
            this.state = false;
        } else if (!this.state && this.currentLevel >= this.onWhenAbove) {
            this.state = true;
        }
        boolean update = previouslyPowered != this.state;
        int displayLevel = 0;
        if (this.currentLevel > 0.0f) {
            displayLevel = (int)(this.currentLevel * 6.0f);
        }
        this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((IProperty)StockpileSwitchBlock.INDICATOR, (Comparable)Integer.valueOf(displayLevel)), update ? 3 : 2);
        if (update) {
            this.field_145850_b.func_195592_c(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
        if (changed || update) {
            this.sendData();
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.updateCurrentLevel();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour(this, new FilteredDetectorFilterSlot()).moveText(new Vec3d(0.0, 5.0, 0.0)).withCallback($ -> this.updateCurrentLevel());
        behaviours.add(this.filtering);
        this.observedInventory = new InvManipulationBehaviour(this, InvManipulationBehaviour.InterfaceProvider.towardBlockFacing()).bypassSidedness();
        behaviours.add(this.observedInventory);
    }

    public float getLevelForDisplay() {
        return this.currentLevel == -1.0f ? 0.0f : this.currentLevel;
    }

    public boolean getState() {
        return this.state;
    }

    public boolean isPowered() {
        return this.inverted != this.state;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        if (inverted == this.inverted) {
            return;
        }
        this.inverted = inverted;
        this.field_145850_b.func_195592_c(this.field_174879_c, this.func_195044_w().func_177230_c());
    }
}

