/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.logistics.item.filter.AbstractFilterContainer;
import com.simibubi.create.content.logistics.item.filter.FilterScreenPacket;
import com.simibubi.create.foundation.gui.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.gui.widgets.Indicator;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public abstract class AbstractFilterScreen<F extends AbstractFilterContainer>
extends AbstractSimiContainerScreen<F> {
    protected AllGuiTextures background;
    private List<Rectangle2d> extraAreas = Collections.EMPTY_LIST;
    private IconButton resetButton;
    private IconButton confirmButton;

    protected AbstractFilterScreen(F container, PlayerInventory inv, ITextComponent title, AllGuiTextures background) {
        super(container, inv, title);
        this.background = background;
    }

    protected void init() {
        this.setWindowSize(AllGuiTextures.PLAYER_INVENTORY.width, this.background.height + AllGuiTextures.PLAYER_INVENTORY.height + 20);
        super.init();
        this.widgets.clear();
        int x = this.field_147003_i - 50;
        int offset = this.field_147009_r < 30 ? 30 - this.field_147009_r : 0;
        this.extraAreas = ImmutableList.of((Object)new Rectangle2d(x, this.field_147009_r + offset, this.background.width + 70, this.background.height - offset));
        this.resetButton = new IconButton(x + this.background.width - 62, this.field_147009_r + this.background.height - 24, AllIcons.I_TRASH);
        this.confirmButton = new IconButton(x + this.background.width - 33, this.field_147009_r + this.background.height - 24, AllIcons.I_CONFIRM);
        this.widgets.add(this.resetButton);
        this.widgets.add(this.confirmButton);
    }

    @Override
    protected void renderWindow(int mouseX, int mouseY, float partialTicks) {
        int x = this.field_147003_i - 50;
        int y = this.field_147009_r;
        this.background.draw((AbstractGui)this, x, y);
        int invX = this.field_147003_i;
        int invY = y + this.background.height + 10;
        AllGuiTextures.PLAYER_INVENTORY.draw((AbstractGui)this, invX, invY);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), (float)(invX + 7), (float)(invY + 6), 0x666666);
        this.font.func_175063_a(I18n.func_135052_a((String)((AbstractFilterContainer)this.field_147002_h).filterItem.func_77977_a(), (Object[])new Object[0]), (float)(x + 15), (float)(y + 3), 0xDEDEDE);
        GuiGameElement.of(((AbstractFilterContainer)this.field_147002_h).filterItem).at(x + this.background.width, this.field_147009_r + this.background.height - 60).scale(5.0).render();
    }

    public void tick() {
        this.handleTooltips();
        super.tick();
        this.handleIndicators();
        if (!((AbstractFilterContainer)this.field_147002_h).player.func_184614_ca().equals(((AbstractFilterContainer)this.field_147002_h).filterItem, false)) {
            this.minecraft.field_71439_g.func_71053_j();
        }
    }

    public void handleIndicators() {
        List<IconButton> tooltipButtons = this.getTooltipButtons();
        for (IconButton button : tooltipButtons) {
            button.active = this.isButtonEnabled(button);
        }
        for (Widget w : this.widgets) {
            if (!(w instanceof Indicator)) continue;
            ((Indicator)w).state = this.isIndicatorOn((Indicator)w) ? Indicator.State.ON : Indicator.State.OFF;
        }
    }

    protected abstract boolean isButtonEnabled(IconButton var1);

    protected abstract boolean isIndicatorOn(Indicator var1);

    protected void handleTooltips() {
        List<IconButton> tooltipButtons = this.getTooltipButtons();
        for (IconButton button : tooltipButtons) {
            if (button.getToolTip().isEmpty()) continue;
            button.setToolTip(button.getToolTip().get(0));
            button.getToolTip().add(TooltipHelper.holdShift(ItemDescription.Palette.Yellow, AbstractFilterScreen.hasShiftDown()));
        }
        if (AbstractFilterScreen.hasShiftDown()) {
            List<String> tooltipDescriptions = this.getTooltipDescriptions();
            for (int i = 0; i < tooltipButtons.size(); ++i) {
                this.fillToolTip(tooltipButtons.get(i), tooltipDescriptions.get(i));
            }
        }
    }

    protected List<IconButton> getTooltipButtons() {
        return Collections.emptyList();
    }

    protected List<String> getTooltipDescriptions() {
        return Collections.emptyList();
    }

    private void fillToolTip(IconButton button, String tooltip) {
        if (!button.isHovered()) {
            return;
        }
        List<String> tip = button.getToolTip();
        tip.addAll(TooltipHelper.cutString(tooltip, TextFormatting.GRAY, TextFormatting.GRAY));
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        boolean mouseClicked = super.mouseClicked(x, y, button);
        if (button == 0) {
            if (this.confirmButton.isHovered()) {
                this.minecraft.field_71439_g.func_71053_j();
                return true;
            }
            if (this.resetButton.isHovered()) {
                ((AbstractFilterContainer)this.field_147002_h).clearContents();
                this.contentsCleared();
                this.sendOptionUpdate(FilterScreenPacket.Option.CLEAR);
                return true;
            }
        }
        return mouseClicked;
    }

    protected void contentsCleared() {
    }

    protected void sendOptionUpdate(FilterScreenPacket.Option option) {
        AllPackets.channel.sendToServer((Object)new FilterScreenPacket(option));
    }

    @Override
    public List<Rectangle2d> getExtraAreas() {
        return this.extraAreas;
    }
}

