/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute;

import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.WrittenBookItem;
import net.minecraft.nbt.CompoundNBT;

public class BookCopyAttribute
implements ItemAttribute {
    int generation;

    public BookCopyAttribute(int generation) {
        this.generation = generation;
    }

    @Override
    public boolean appliesTo(ItemStack itemStack) {
        return this.extractGeneration(itemStack) == this.generation;
    }

    @Override
    public List<ItemAttribute> listAttributesOf(ItemStack itemStack) {
        int generation = this.extractGeneration(itemStack);
        ArrayList<ItemAttribute> atts = new ArrayList<ItemAttribute>();
        if (generation >= 0) {
            atts.add(new BookCopyAttribute(generation));
        }
        return atts;
    }

    @Override
    public String getTranslationKey() {
        switch (this.generation) {
            case 0: {
                return "book_copy_original";
            }
            case 1: {
                return "book_copy_first";
            }
            case 2: {
                return "book_copy_second";
            }
        }
        return "book_copy_tattered";
    }

    @Override
    public void writeNBT(CompoundNBT nbt) {
        nbt.func_74768_a("generation", this.generation);
    }

    @Override
    public ItemAttribute readNBT(CompoundNBT nbt) {
        return new BookCopyAttribute(nbt.func_74762_e("generation"));
    }

    private int extractGeneration(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && stack.func_77973_b() instanceof WrittenBookItem) {
            return nbt.func_74762_e("generation");
        }
        return -1;
    }
}

