/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute;

import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.DyeColor;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.FireworkStarItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.TranslationTextComponent;

public class ColorAttribute
implements ItemAttribute {
    public static final ColorAttribute EMPTY = new ColorAttribute(DyeColor.PURPLE);
    public final DyeColor color;

    public ColorAttribute(DyeColor color) {
        this.color = color;
    }

    @Override
    public boolean appliesTo(ItemStack itemStack) {
        return this.findMatchingDyeColors(itemStack).stream().anyMatch(arg_0 -> this.color.equals(arg_0));
    }

    @Override
    public List<ItemAttribute> listAttributesOf(ItemStack itemStack) {
        return this.findMatchingDyeColors(itemStack).stream().map(ColorAttribute::new).collect(Collectors.toList());
    }

    private Collection<DyeColor> findMatchingDyeColors(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        DyeColor color = DyeColor.getColor((ItemStack)stack);
        if (color != null) {
            return Collections.singletonList(color);
        }
        HashSet<DyeColor> colors = new HashSet<DyeColor>();
        if (stack.func_77973_b() instanceof FireworkRocketItem && nbt != null) {
            ListNBT listnbt = nbt.func_74775_l("Fireworks").func_150295_c("Explosions", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                colors.addAll(this.getFireworkStarColors(listnbt.func_150305_b(i)));
            }
        }
        if (stack.func_77973_b() instanceof FireworkStarItem && nbt != null) {
            colors.addAll(this.getFireworkStarColors(nbt.func_74775_l("Explosion")));
        }
        Arrays.stream(DyeColor.values()).filter(c -> stack.func_77973_b().getRegistryName().func_110623_a().startsWith(c.func_176762_d() + "_")).forEach(colors::add);
        return colors;
    }

    private Collection<DyeColor> getFireworkStarColors(CompoundNBT compound) {
        HashSet<DyeColor> colors = new HashSet<DyeColor>();
        Arrays.stream(compound.func_74759_k("Colors")).mapToObj(DyeColor::func_196058_b).forEach(colors::add);
        Arrays.stream(compound.func_74759_k("FadeColors")).mapToObj(DyeColor::func_196058_b).forEach(colors::add);
        return colors;
    }

    @Override
    public String getTranslationKey() {
        return "color";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{new TranslationTextComponent(this.color.func_176762_d(), new Object[0]).func_150254_d()};
    }

    @Override
    public void writeNBT(CompoundNBT nbt) {
        nbt.func_74768_a("id", this.color.func_196059_a());
    }

    @Override
    public ItemAttribute readNBT(CompoundNBT nbt) {
        return nbt.func_74764_b("id") ? new ColorAttribute(DyeColor.func_196056_a((int)nbt.func_74762_e("id"))) : EMPTY;
    }
}

