/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute;

import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FluidContentsAttribute
implements ItemAttribute {
    public static final FluidContentsAttribute EMPTY = new FluidContentsAttribute(null);
    private final Fluid fluid;

    public FluidContentsAttribute(@Nullable Fluid fluid) {
        this.fluid = fluid;
    }

    @Override
    public boolean appliesTo(ItemStack itemStack) {
        return this.extractFluids(itemStack).contains(this.fluid);
    }

    @Override
    public List<ItemAttribute> listAttributesOf(ItemStack itemStack) {
        return this.extractFluids(itemStack).stream().map(FluidContentsAttribute::new).collect(Collectors.toList());
    }

    @Override
    public String getTranslationKey() {
        return "has_fluid";
    }

    @Override
    public Object[] getTranslationParameters() {
        String parameter = "";
        if (this.fluid != null) {
            parameter = new TranslationTextComponent(this.fluid.getAttributes().getTranslationKey(), new Object[0]).getString();
        }
        return new Object[]{parameter};
    }

    @Override
    public void writeNBT(CompoundNBT nbt) {
        if (this.fluid == null) {
            return;
        }
        ResourceLocation id = ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)this.fluid);
        if (id == null) {
            return;
        }
        nbt.func_74778_a("id", id.toString());
    }

    @Override
    public ItemAttribute readNBT(CompoundNBT nbt) {
        return nbt.func_74764_b("id") ? new FluidContentsAttribute((Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.func_208304_a((String)nbt.func_74779_i("id")))) : EMPTY;
    }

    private List<Fluid> extractFluids(ItemStack stack) {
        ArrayList<Fluid> fluids = new ArrayList<Fluid>();
        LazyOptional capability = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        capability.ifPresent(cap -> {
            for (int i = 0; i < cap.getTanks(); ++i) {
                fluids.add(cap.getFluidInTank(i).getFluid());
            }
        });
        return fluids;
    }
}

